/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class ProfileDetailsPropertyPage
extends ProfilePropertyPage {
    protected Button btnPing;

    protected ProfileDetailsPropertyPage() {
        super(true);
    }

    protected Control createContents(Composite parent) {
        Composite container = (Composite)super.createContents(parent);
        this.btnPing = new Button(container, 0);
        this.btnPing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDetailsPropertyPage.this.testConnection();
            }
        });
        this.btnPing.setLayoutData((Object)new GridData(128));
        this.btnPing.setText(ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.Button.TestConnection"));
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_PROFILE_DETAILS_PROPERTY_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        return container;
    }

    protected void testConnection() {
        IConnectionProfile cp = this.getConnectionProfile();
        ConnectionProfile profile = new ConnectionProfile(cp.getName(), cp.getDescription(), cp.getProviderId(), cp.getParentProfile() == null ? "" : cp.getParentProfile().getName(), false);
        profile.setBaseProperties(this.collectProperties());
        final PingJob pingJob = new PingJob(this.getShell(), (IConnectionProfile)profile);
        pingJob.schedule();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    protected void setPingButtonEnabled(boolean enabled) {
        if (this.btnPing != null && !this.btnPing.isDisposed()) {
            this.btnPing.setEnabled(enabled);
        }
    }

    protected void setPingButtonVisible(boolean visible) {
        if (this.btnPing != null && !this.btnPing.isDisposed()) {
            this.btnPing.setVisible(visible);
        }
    }
}

