/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Properties;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCreateChange;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizardPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class NewConnectionProfileWizard
extends BaseWizard
implements INewWizard,
ICPWizard,
IContextProvider {
    protected NewConnectionProfileWizardPage mProfilePage;
    protected SummaryWizardPage mSummaryPage;
    protected String mProviderID;
    protected IConnectionProfile mParentProfile;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public NewConnectionProfileWizard() {
        this.setWindowTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.title"));
        this.setDefaultPageImageDescriptor(SharedImages.DESC_WIZBAN);
    }

    public boolean performFinish() {
        try {
            this.doFinish();
        }
        catch (CoreException e) {
            ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.create.failure"), e.getLocalizedMessage(), e);
            return false;
        }
        return true;
    }

    private void doFinish() throws CoreException {
        IConnectionProfile repo = this.mProfilePage.getRepository();
        PerformChangeOperation refOperation = new PerformChangeOperation((Change)new ConnectionProfileCreateChange(this.mProfilePage.getProfileName(), this.mProfilePage.getProfileDescription(), this.mProviderID, this.getProfileProperties(), repo == null ? null : repo.getName(), this.mProfilePage.getAutoConnect(), this.getShell()));
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
        catch (OperationCanceledException oce) {
            throw new OperationCanceledException();
        }
        catch (CoreException ce) {
            throw ce;
        }
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
        if (part != null) {
            StructuredSelection targetSelection = new StructuredSelection((Object)ProfileManager.getInstance().getProfileByName(this.getProfileName()));
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target != null) {
                final ISetSelectionTarget finalTarget = target;
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = val$targetSelection;
                    }

                    public void run() {
                        finalTarget.selectReveal(this.val$targetSelection);
                    }
                });
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void initProviderID(String providerID) {
        this.mProviderID = providerID;
    }

    public abstract void addCustomPages();

    public String getProfileProviderID() {
        return this.mProviderID;
    }

    public String getProfileName() {
        return this.mProfilePage.getProfileName();
    }

    public String getProfileDescription() {
        return this.mProfilePage.getProfileDescription();
    }

    public boolean getProfileIsAutoConnect() {
        return this.mProfilePage.getAutoConnect();
    }

    public abstract Properties getProfileProperties();

    public String getParentProfile() {
        return this.mParentProfile == null ? new String() : this.mParentProfile.getName();
    }

    public void setParentProfile(IConnectionProfile profile) {
        this.mParentProfile = profile;
    }

    public void addPages() {
        super.addPages();
        this.mProfilePage = new NewConnectionProfileWizardPage();
        this.addPage((IWizardPage)this.mProfilePage);
        this.addCustomPages();
        this.mSummaryPage = new SummaryWizardPage(this);
        this.addPage(this.mSummaryPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_CONNECTION_PROFILE_WIZARD", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

