/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ImportProfilesDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class ImportProfileViewAction
extends Action
implements IViewActionDelegate {
    private Shell shell;
    private CommonNavigator commonNav;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository;

    public ImportProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.importCPs"));
    }

    public void init(IViewPart view) {
        if (view instanceof CommonNavigator) {
            this.commonNav = (CommonNavigator)view;
        }
        this.shell = view.getSite().getShell();
    }

    public void run() {
        final ImportProfilesDialog dlg = new ImportProfilesDialog(this.shell);
        int ret = dlg.open();
        if (ret == 0) {
            final IConnectionProfile[] profiles = dlg.getProfiles();
            if (profiles == null) {
                ExceptionHandler.showException(this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), dlg.getException().getMessage(), dlg.getException());
                return;
            }
            if (dlg.getUseLocalRepository()) {
                BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ProfileManager manager = ProfileManager.getInstance();
                        try {
                            for (int i = 0; i < profiles.length; ++i) {
                                if (manager.getProfileByName(profiles[i].getName()) == null) {
                                    ((ConnectionProfile)profiles[i]).migrate();
                                    manager.addProfile(profiles[i]);
                                    continue;
                                }
                                if (!dlg.isOverwritten()) continue;
                                ((ConnectionProfile)profiles[i]).migrate();
                                manager.modifyProfile(profiles[i]);
                            }
                        }
                        catch (ConnectionProfileException e) {
                            ExceptionHandler.showException(ImportProfileViewAction.this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                        }
                    }
                });
            } else {
                BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            IConnectionProfile repoProfile = dlg.getSelectedRepository();
                            IConnectionProfileRepository repo = (IConnectionProfileRepository)repoProfile.getManagedConnection((class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository == null ? (class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository = ImportProfileViewAction.class$("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository")) : class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository).getName()).getConnection().getRawConnection();
                            for (int i = 0; i < profiles.length; ++i) {
                                if (!repo.supportsProfileType(profiles[i].getProviderId()) || !((ConnectionProfileProvider)profiles[i].getProvider()).compatibleWithRepository(repoProfile)) continue;
                                if (repo.getProfileByName(profiles[i].getName()) == null) {
                                    ((ConnectionProfile)profiles[i]).migrate();
                                    repo.addProfile(profiles[i]);
                                    continue;
                                }
                                if (!dlg.isOverwritten()) continue;
                                ((ConnectionProfile)profiles[i]).migrate();
                                repo.modifyProfile(profiles[i]);
                            }
                        }
                        catch (ConnectionProfileException e) {
                            ExceptionHandler.showException(ImportProfileViewAction.this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                        }
                    }
                });
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

