/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardSelectionPage;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewCPWizard
extends BaseWizard
implements INewWizard,
IContextProvider {
    private CPWizardSelectionPage mProfilePage;
    private ViewerFilter mViewerFilter;
    private IConnectionProfile mParentProfile;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public NewCPWizard() {
        this.setDefaultPageImageDescriptor(SharedImages.DESC_WIZBAN);
        this.setWindowTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewCPWizard.title"));
    }

    public NewCPWizard(ViewerFilter filter, IConnectionProfile parentProfile) {
        this();
        this.mViewerFilter = filter;
        this.mParentProfile = parentProfile;
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        super.addPages();
        this.mProfilePage = new CPWizardSelectionPage(CPWizardSelectionPage.class.getName(), this.mViewerFilter);
        this.addPage((IWizardPage)this.mProfilePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.mViewerFilter == null) {
            this.mViewerFilter = new NewCPWizardCategoryFilter(null);
        }
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public IConnectionProfile getParentProfile() {
        return this.mParentProfile;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_CP_WIZARD", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

