/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DropListViewer;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class RepositoriesDropList
extends DropListViewer {
    private RepositoriesFilter mRepositoriesFilter;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository;

    public RepositoriesDropList(ConnectionProfileProvider profileProvider, Composite parent) {
        super(parent);
        this.setContentProvider((IContentProvider)new RepositoriesContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new RepositoriesLabelProvider());
        this.mRepositoriesFilter = new RepositoriesFilter(profileProvider);
        this.addFilter(this.mRepositoriesFilter);
    }

    public boolean hasRepositories() {
        return this.mRepositoriesFilter.hasRepositories();
    }

    private static class RepositoriesContentProvider
    implements IStructuredContentProvider {
        private RepositoriesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RepositoriesFilter
    extends ViewerFilter {
        private ConnectionProfileProvider mProfileProvider;
        private boolean mHasRepositories;

        public RepositoriesFilter(ConnectionProfileProvider profileProvider) {
            this.mProfileProvider = profileProvider;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ConnectionProfile repo = (ConnectionProfile)element;
            IManagedConnection managedConnection = repo.getManagedConnection((class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository == null ? (class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository = RepositoriesDropList.class$("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository")) : class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository).getName());
            IConnectionProfileRepository repoConn = managedConnection.isConnected() ? (IConnectionProfileRepository)managedConnection.getConnection().getRawConnection() : null;
            boolean retVal = repoConn != null && !repoConn.isReadOnly() && (this.mProfileProvider == null || this.mProfileProvider.compatibleWithRepository((IConnectionProfile)repo) && repoConn.supportsProfileType(this.mProfileProvider.getId()));
            this.mHasRepositories |= retVal;
            return retVal;
        }

        public boolean hasRepositories() {
            return this.mHasRepositories;
        }
    }

    private static class RepositoriesLabelProvider
    extends LabelProvider {
        private RepositoriesLabelProvider() {
        }

        public Image getImage(Object element) {
            IConnectionProfile profile = (IConnectionProfile)element;
            return ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider());
        }

        public String getText(Object element) {
            IConnectionProfile profile = (IConnectionProfile)element;
            StringBuffer sb = new StringBuffer(profile.getName());
            if (profile.getConnectionState() != 0) {
                Properties props = profile.getProperties("org.eclipse.datatools.connectivity.versionInfo");
                String serverName = props.getProperty("server.name");
                Version serverVersion = Version.valueOf((String)props.getProperty("server.version"));
                if (serverName != null && serverName.length() > 0 || serverVersion != Version.NULL_VERSION) {
                    String versionStr = MessageFormat.format((String)ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.version"), (Object[])new String[]{profile.getName(), serverName, serverVersion.toString()});
                    sb = new StringBuffer(versionStr);
                }
            }
            return sb.toString();
        }
    }
}

