/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.IConnectionProfileActionFilter;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectionProfileActionFilter
extends PropertyTester
implements IConnectionProfileActionFilter,
IPropertyTester {
    public boolean testAttribute(Object target, String name, String value) {
        if (target == null || !(target instanceof IConnectionProfile)) {
            return false;
        }
        IConnectionProfile profile = (IConnectionProfile)target;
        if (name.equals("org.eclipse.datatools.profile.property.id") || name.equals("id")) {
            return profile.getProviderId().equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.categoryID") || name.equals("categoryID")) {
            return profile.getCategory().getId().equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.hasExtendedProperties") || name.equals("hasExtendedProperties")) {
            return profile.getProvider().getProfileExtensions().size() != 0;
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.extensionID") || name.equals("extensionID")) {
            return profile.getProvider().getProfileExtensions().containsKey(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.maintainConnection") || name.equals("maintainConnection")) {
            return profile.getProvider().needsMaintainConnection();
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.isConnected") || name.equals("isConnected")) {
            return profile.isConnected();
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.supportsPing") || name.equals("supportsPing")) {
            return profile.getProvider().getConnectionFactories().containsKey("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.factoryID") || name.equals("factoryID")) {
            return profile.getProvider().getConnectionFactories().containsKey(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.containingViewID") || name.equals("containingViewID")) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IViewPart) {
                IViewPart view = (IViewPart)part;
                String viewID = view.getViewSite().getId();
                return viewID.equals(value);
            }
            return false;
        }
        if (name.equals("org.eclipse.datatools.connectivity.profile.property.connectionState") || name.equals("connectionState")) {
            return profile.getConnectionState() == this.getConnectionStateFromString(value);
        }
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return this.testAttribute(receiver, property, expectedValue == null ? null : expectedValue.toString());
    }

    private int getConnectionStateFromString(String value) {
        if ("DISCONNECTED".equalsIgnoreCase(value)) {
            return 0;
        }
        if ("CONNECTED".equalsIgnoreCase(value)) {
            return 1;
        }
        if ("WORKING_OFFLINE".equalsIgnoreCase(value)) {
            return 2;
        }
        return -1;
    }
}

