/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.IElementIDProvider;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public class TransientEObjectUtil
implements IElementIDProvider {
    private static final ContainmentService containment = RDBCorePlugin.getDefault().getContainmentService();
    private static final String SEPARATOR = "#";
    private static final String VIRTUAL_SEPARATOR = "/";
    private static final String NULL = "";
    private static final Stack stack = new Stack();

    private static EObject getRoot(EObject object) {
        stack.push(object);
        do {
            EObject parent = null;
            parent = containment.getContainer(object);
            if (parent == null) {
                return object;
            }
            object = parent;
            stack.push(object);
        } while (object != null);
        return object;
    }

    public static ConnectionInfo getConnectionInfo(EObject object) {
        return null;
    }

    private static IConnectionNode getConnectionNode(EObject object) throws Exception {
        return ConnectionNodeUtil.getConnectionNode(TransientEObjectUtil.getConnectionInfo(object));
    }

    private static void buildID(StringBuffer buffer, String name) {
        buffer.append(String.valueOf(name) + SEPARATOR);
    }

    private static void buildID(StringBuffer buffer) {
        while (!stack.empty()) {
            ENamedElement eObject = (ENamedElement)stack.pop();
            String groupID = containment.getGroupId((EObject)eObject);
            buffer.append(String.valueOf(groupID) + VIRTUAL_SEPARATOR + eObject.getName() + SEPARATOR);
        }
    }

    public static String getEObjectId(EObject object) throws Exception {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public static List getPathFromID(String id) {
        StringTokenizer tokens = new StringTokenizer(id, SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        while (tokens.hasMoreElements()) {
            list.add(tokens.nextToken());
        }
        return list;
    }

    public static IGroup getGroupInfo(final String subId) {
        return new IGroup(){

            public String getGroupId() {
                return subId.substring(0, subId.indexOf(TransientEObjectUtil.VIRTUAL_SEPARATOR));
            }

            public String getElementName() {
                String elementName = subId.substring(subId.indexOf(TransientEObjectUtil.VIRTUAL_SEPARATOR) + 1);
                return elementName.equals(TransientEObjectUtil.NULL) ? null : elementName;
            }
        };
    }

    public static EObject getEObjectFromId(String id) {
        return null;
    }

    public String getElementID(EObject eObject) {
        try {
            return TransientEObjectUtil.getEObjectId(eObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface IGroup {
        public String getGroupId();

        public String getElementName();
    }
}

