/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCTable;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCTemporaryTable;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCView;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.ReferenceType;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.emf.ecore.EClass;

public class JDBCTableLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TABLE_NAME = "TABLE_NAME";
    public static final String COLUMN_TABLE_TYPE = "TABLE_TYPE";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    public static final String COLUMN_REF_GENERATION = "REF_GENERATION";
    public static final String TYPE_TABLE = "TABLE";
    public static final String TYPE_VIEW = "VIEW";
    public static final String TYPE_SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TYPE_GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String TYPE_LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    public static final String TYPE_REF_SYSTEM = "SYSTEM";
    public static final String TYPE_REF_USER = "USER";
    public static final String TYPE_REF_DERIVED = "DERIVED";
    private Map mTableFactories;
    private boolean mSupportedColumnsInitialized;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public JDBCTableLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaObjectFilterProvider("DatatoolsTableFilterPredicate"));
    }

    public JDBCTableLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Schema)) {
            throw new AssertionError();
        }
        this.mTableFactories = new HashMap(5);
        this.registerTableFactory(TYPE_TABLE, new TableFactory());
        this.registerTableFactory(TYPE_VIEW, new ViewFactory());
        this.registerTableFactory(TYPE_SYSTEM_TABLE, new TableFactory());
        this.registerTableFactory(TYPE_GLOBAL_TEMPORARY, new GlobalTempTableFactory());
        this.registerTableFactory(TYPE_LOCAL_TEMPORARY, new LocalTempTableFactory());
    }

    public List loadTables() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadTables(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    /*
     * Exception decompiling
     */
    public void loadTables(List containmentList, Collection existingTables) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 283->287)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearTables(List tables) {
        tables.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Schema schema = this.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getTables(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern(), null);
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getTables()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Table processRow(ResultSet rs) throws SQLException {
        ITableFactory tableFactory = this.getTableFactory(rs.getString(COLUMN_TABLE_TYPE));
        if (tableFactory == null) {
            return null;
        }
        return tableFactory.createTable(rs);
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }

    public ITableFactory registerTableFactory(String type, ITableFactory factory) {
        return this.mTableFactories.put(type, factory);
    }

    public ITableFactory unregisterTableFactory(String type) {
        return (ITableFactory)this.mTableFactories.remove(type);
    }

    public ITableFactory getTableFactory(String type) {
        if (this.mTableFactories.containsKey(type)) {
            return (ITableFactory)this.mTableFactories.get(type);
        }
        return null;
    }

    public static class GlobalTempTableFactory
    extends TableFactory {
        public EClass getTableEClass() {
            return SQLTablesPackage.eINSTANCE.getTemporaryTable();
        }

        protected Table newTable() {
            return new JDBCTemporaryTable();
        }
    }

    public static interface ITableFactory {
        public EClass getTableEClass();

        public Table createTable(ResultSet var1) throws SQLException;

        public void initialize(Table var1, ResultSet var2) throws SQLException;

        public void setSupportedColumns(Set var1);
    }

    public static class LocalTempTableFactory
    extends TableFactory {
        protected Table newTable() {
            return new JDBCTemporaryTable();
        }

        public void initialize(Table table, ResultSet rs) throws SQLException {
            super.initialize(table, rs);
            ((TemporaryTable)table).setLocal(true);
        }
    }

    public static class TableFactory
    implements ITableFactory {
        protected Set mSupportedColumns;

        public EClass getTableEClass() {
            return SQLTablesPackage.eINSTANCE.getPersistentTable();
        }

        public Table createTable(ResultSet rs) throws SQLException {
            Table retVal = this.newTable();
            this.initialize(retVal, rs);
            return retVal;
        }

        public void setSupportedColumns(Set supportedColumns) {
            this.mSupportedColumns = supportedColumns;
        }

        protected Table newTable() {
            return new JDBCTable();
        }

        public void initialize(Table table, ResultSet rs) throws SQLException {
            if (this.mSupportedColumns.contains(JDBCTableLoader.COLUMN_REF_GENERATION)) {
                String srcg = rs.getString(JDBCTableLoader.COLUMN_REF_GENERATION);
                if (JDBCTableLoader.TYPE_REF_SYSTEM.equals(srcg)) {
                    table.setSelfRefColumnGeneration(ReferenceType.SYSTEM_GENERATED_LITERAL);
                } else if (JDBCTableLoader.TYPE_REF_USER.equals(srcg)) {
                    table.setSelfRefColumnGeneration(ReferenceType.USER_GENERATED_LITERAL);
                } else if (JDBCTableLoader.TYPE_REF_DERIVED.equals(srcg)) {
                    table.setSelfRefColumnGeneration(ReferenceType.DERIVED_SELF_REF_LITERAL);
                }
            }
            table.setName(rs.getString(JDBCTableLoader.COLUMN_TABLE_NAME));
            if (this.mSupportedColumns.contains(JDBCTableLoader.COLUMN_REMARKS)) {
                table.setDescription(rs.getString(JDBCTableLoader.COLUMN_REMARKS));
            }
        }

        protected Column createColumn() {
            return new JDBCColumn();
        }
    }

    public static class ViewFactory
    extends TableFactory {
        public EClass getTableEClass() {
            return SQLTablesPackage.eINSTANCE.getViewTable();
        }

        protected Table newTable() {
            return new JDBCView();
        }
    }
}

