/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.connection;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.StatementAdapter;

public class ConnectionAdapter
implements Connection {
    private ConnectionInfoImpl info;
    private Connection connection;

    public ConnectionAdapter(ConnectionInfo info, Connection connection) {
        this.info = (ConnectionInfoImpl)info;
        this.connection = connection;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.info;
    }

    public Connection getNativeConnection() {
        return this.connection;
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement s = this.connection.createStatement();
            return new StatementAdapter(this, s);
        }
        catch (SQLException e) {
            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, e.getClass().getName(), (Throwable)e);
            RDBCorePlugin.getDefault().getLog().log((IStatus)status);
            this.info.onSQLException(this, e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        return this.connection.prepareStatement(arg0);
    }

    public CallableStatement prepareCall(String arg0) throws SQLException {
        return this.connection.prepareCall(arg0);
    }

    public String nativeSQL(String arg0) throws SQLException {
        return this.nativeSQL(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        this.connection.setAutoCommit(arg0);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.connection.setReadOnly(arg0);
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setCatalog(String arg0) throws SQLException {
        this.connection.setCatalog(arg0);
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this.connection.setTransactionIsolation(arg0);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        return this.connection.createStatement(arg0, arg1);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        return this.connection.prepareStatement(arg0, arg1, arg2);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        return this.connection.prepareCall(arg0, arg1, arg2);
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.connection.setTypeMap(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this.connection.setHoldability(arg0);
    }

    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.connection.setSavepoint(arg0);
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this.connection.rollback(arg0);
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.connection.releaseSavepoint(arg0);
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        return this.connection.createStatement(arg0, arg1, arg2);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return this.connection.prepareStatement(arg0, arg1, arg2, arg3);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return this.prepareCall(arg0, arg1, arg2, arg3);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        return this.prepareStatement(arg0, arg1);
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        return this.prepareStatement(arg0, arg1);
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        return this.prepareStatement(arg0, arg1);
    }
}

