/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;

public class JDBCBaseLoader {
    private ICatalogObject mCatalogObject;
    private IConnectionFilterProvider mConnectionFilterProvider;
    private ConnectionFilter mActiveFilter;

    public JDBCBaseLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this.mCatalogObject = catalogObject;
        this.mConnectionFilterProvider = connectionFilterProvider;
    }

    public ICatalogObject getCatalogObject() {
        return this.mCatalogObject;
    }

    protected void initActiveFilter() {
        this.mActiveFilter = null;
        if (this.mConnectionFilterProvider != null) {
            this.mActiveFilter = this.mConnectionFilterProvider.getConnectionFilter(this.mCatalogObject);
        }
    }

    protected String getJDBCFilterPattern() {
        if (this.mActiveFilter != null && "LIKE".equals(this.mActiveFilter.getOperator())) {
            return this.mActiveFilter.getPattern();
        }
        return null;
    }

    protected String getSQLFilterExpression() {
        if (this.mActiveFilter == null) {
            return null;
        }
        return this.mActiveFilter.getPredicate();
    }

    protected boolean isFiltered(String name) {
        if (this.mActiveFilter == null) {
            return false;
        }
        return this.mActiveFilter.isFiltered(name);
    }
}

