/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc;

import com.ibm.icu.util.StringTokenizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc.JDBCDatabase;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc.JDBCTable;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc.JDBCView;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SchemaImpl;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCSchema
extends SchemaImpl
implements ICatalogObject {
    private boolean tablesLoaded = false;
    private transient ConnectionFilterListener filterListener = new ConnectionFilterListener(){

        public void connectionFilterAdded(String filterKey) {
            JDBCSchema.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            JDBCSchema.this.handleFilterChanged(filterKey);
        }
    };

    public synchronized void refresh() {
        this.tablesLoaded = false;
        RefreshManager.getInstance().referesh(this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((JDBCDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getTables();
        }
        return super.eIsSet(eFeature);
    }

    public NotificationChain basicSetDatabase(Database newDatabase, NotificationChain msgs) {
        ConnectionInfo connectionInfo;
        if (this.database != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.database);
            connectionInfo.removeFilterListener(this.filterListener);
        }
        if (newDatabase != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(newDatabase);
            connectionInfo.addFilterListener(this.filterListener);
        }
        return super.basicSetDatabase(newDatabase, msgs);
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            JDBCSchema.loadTables(connection, tableList, (Schema)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tablesLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadTables(Connection connection, EList tableList, Schema schema) throws SQLException {
        Object[] oldList = tableList.toArray();
        tableList.clear();
        try {
            ConnectionInfo connectionInfo;
            ConnectionFilter filter;
            String catalogName = null;
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.supportsCatalogsInTableDefinitions()) {
                catalogName = connection.getCatalog();
            }
            if ((filter = (connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(schema.getDatabase())).getFilter(schema.getName() + "::" + "DatatoolsTableFilterPredicate")) == null) {
                filter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
            }
            String[] tableAry = null;
            String pattern = null;
            if (filter != null) {
                String tableFilter = filter.getPredicate();
                if ((tableFilter = tableFilter.replaceAll(" ", "")).startsWith("IN(")) {
                    tableFilter = tableFilter.substring(3, tableFilter.length() - 1);
                    tableFilter = tableFilter.replaceAll(",", "");
                    tableAry = JDBCSchema.parseINClause(tableFilter);
                }
                if (tableFilter.startsWith("LIKE")) {
                    pattern = JDBCSchema.parseLikeClause(filter.getPredicate());
                }
            }
            ResultSet r = null;
            r = pattern != null ? metaData.getTables(catalogName, schema.getName(), pattern, new String[]{"TABLE", "VIEW", "SYSTEM TABLE"}) : metaData.getTables(catalogName, schema.getName(), null, new String[]{"TABLE", "VIEW", "TABLE_VIEW", "SYSTEM TABLE"});
            while (r.next()) {
                Object table;
                String tableName = r.getString(3);
                String type = r.getString(4);
                String remarks = r.getString(5);
                if (tableAry != null) {
                    boolean found = false;
                    for (int i = 0; i < tableAry.length; ++i) {
                        if (!tableName.equals(tableAry[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                EClass metaclass = null;
                if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getPersistentTable();
                } else if (type.equals("VIEW")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getViewTable();
                }
                Object element = JDBCSchema.findElement(oldList, tableName, metaclass);
                if (element != null) {
                    table = (Table)element;
                    ((ICatalogObject)table).refresh();
                } else {
                    if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                        table = new JDBCTable();
                    } else {
                        if (!type.equals("VIEW")) continue;
                        table = new JDBCView();
                    }
                    table.setName(tableName);
                }
                table.setDescription(remarks);
                tableList.add(table);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        for (int i = 0; i < list.length; ++i) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (!sqlObject.getName().equals(name) || sqlObject.eClass() != metaclass) continue;
            object = list[i];
            break;
        }
        return object;
    }

    protected static String[] parseINClause(String toParse) {
        StringTokenizer tokenizer = new StringTokenizer(toParse, "'");
        Vector<String> list = new Vector<String>();
        Object result = null;
        if (tokenizer.countTokens() >= 1) {
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        String[] retStrList = null;
        if (list.size() > 0) {
            retStrList = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                retStrList[i] = (String)list.get(i);
            }
        }
        return retStrList;
    }

    protected static String parseLikeClause(String toParse) {
        String retString = toParse.substring(toParse.indexOf("'") + 1, toParse.length() - 1);
        return retString;
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.tablesLoaded && (filterKey.equals(this.getTableFilterKey()) || conInf != null && "DatatoolsTableFilterPredicate".equals(filterKey) && conInf.getFilter(this.getTableFilterKey()) == null)) {
            this.tablesLoaded = false;
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh(this);
        }
    }

    private String getTableFilterKey() {
        return this.getName() + "::" + "DatatoolsTableFilterPredicate";
    }
}

