/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceUtil {
    public static void resolveDanglingReferences(Resource resource) {
        HashSet visited = new HashSet();
        LinkedList roots = new LinkedList();
        roots.addAll(resource.getContents());
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            ResourceUtil.resolveDanglingReferencesInternal(resource, (EObject)it.next(), visited);
        }
    }

    private static void resolveDanglingReferencesInternal(Resource resource, EObject obj, Set visited) {
        visited.add(obj);
        LinkedList references = new LinkedList();
        references.addAll(obj.eCrossReferences());
        Iterator it = references.iterator();
        while (it.hasNext()) {
            EObject reference = (EObject)it.next();
            if (reference.eResource() == null) {
                EObject needResource = reference;
                while (needResource.eContainer() != null) {
                    needResource = needResource.eContainer();
                }
                resource.getContents().add((Object)needResource);
            }
            if (visited.contains(reference)) continue;
            ResourceUtil.resolveDanglingReferencesInternal(resource, reference, visited);
        }
        LinkedList contents = new LinkedList();
        contents.addAll(obj.eContents());
        it = contents.iterator();
        while (it.hasNext()) {
            EObject content = (EObject)it.next();
            if (visited.contains(content)) continue;
            ResourceUtil.resolveDanglingReferencesInternal(resource, content, visited);
        }
    }

    public static EObject[] getRootElements(Resource resource) {
        EObject obj;
        ContainmentService s = ContainmentServiceImpl.INSTANCE;
        ArrayList<EObject> roots = new ArrayList<EObject>();
        Iterator it = resource.getContents().iterator();
        while (it.hasNext() && s.getContainer(obj = (EObject)it.next()) == null) {
            roots.add(obj);
        }
        EObject[] r = new EObject[roots.size()];
        roots.toArray(r);
        return r;
    }
}

