/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.ui.explorer.filter;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ConnectionFilterComposite;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public abstract class ConnectionFilterWizardPage
extends WizardPage
implements IConnectionFilterProvider {
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    protected ISelection selection;
    private String DEFAULT_MESSAGE = resource.queryString("_UI_DESCRIPTION_FILTER");
    private static final String SELECTION_ONLY_MESSAGE = resource.queryString("_UI_DESCRIPTION_SELECTION_ONLY");
    private static final String EXPRESSION_ONLY_MESSAGE = resource.queryString("_UI_DESCRIPTION_EXPRESSION_ONLY");
    protected String defaultTitleText = "Connection Filter Properties";
    private ConnectionFilterComposite filterComposite;

    public ConnectionFilterWizardPage(String pageName) {
        super(pageName);
        this.setDescription(this.DEFAULT_MESSAGE);
    }

    protected ConnectionFilterWizardPage(String pageName, String title, ImageDescriptor titleImage, ISelection sel) {
        super(pageName, title, titleImage);
        this.selection = sel;
        this.setMessage(this.DEFAULT_MESSAGE);
    }

    public void createControl(Composite parent) {
        this.createControl(parent, false, false);
    }

    public void createControl(Composite parent, boolean hideExpressionOption, boolean hideSelectionOption) {
        this.filterComposite = new ConnectionFilterComposite(parent, 0, this, hideExpressionOption, hideSelectionOption);
        this.filterComposite.initializeValues();
        if (this.filterComposite.isHideExpressionOption()) {
            this.DEFAULT_MESSAGE = SELECTION_ONLY_MESSAGE;
            this.setDescription(this.DEFAULT_MESSAGE);
        } else if (this.filterComposite.isHideSelectionOption()) {
            this.DEFAULT_MESSAGE = EXPRESSION_ONLY_MESSAGE;
            this.setDescription(this.DEFAULT_MESSAGE);
        } else {
            this.setDescription(this.DEFAULT_MESSAGE);
        }
        this.setControl((Control)this.filterComposite);
        this.validatePage();
    }

    protected void initializeValues() {
        this.filterComposite.initializeValues();
    }

    protected boolean validatePage() {
        return this.filterComposite.validatePage((DialogPage)this);
    }

    public void dataChanged() {
        this.validatePage();
    }

    public String getPredicate() {
        return this.filterComposite.getPredicate();
    }

    public boolean isFilterSpecified() {
        return this.filterComposite.isFilterSpecified();
    }

    public boolean isIncludeSelected() {
        return this.filterComposite.isFilterSpecified();
    }

    public void populateSelectionTable(Table selectionTable) {
        this.filterComposite.populateSelectionTable(selectionTable);
    }

    public void populateSelectionTable() {
        this.filterComposite.populateSelectionTable();
    }

    public abstract ConnectionFilter getConnectionFilter();
}

