/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class FilterListSelectionDialog
extends CheckedTreeSelectionDialog {
    private Text filterText;
    private List checkedItems = new ArrayList();

    public FilterListSelectionDialog(Shell parentShell, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this(parentShell, contentProvider, labelProvider, new ListSelectionFilter());
    }

    public FilterListSelectionDialog(Shell parentShell, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ListSelectionFilter filter) {
        super(parentShell, labelProvider, contentProvider);
        this.addFilter(filter);
        this.setMessage(ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.DIALOGS.FILTERLISTSELECTIONDIALOG.MESSAGE"));
        this.setTitle(ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.DIALOGS.FILTERLISTSELECTIONDIALOG.TITLE"));
        this.setContainerMode(true);
    }

    protected void computeResult() {
        this.setResult(this.checkedItems);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        parentComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(1808);
        parentComposite.setLayoutData((Object)data);
        Composite filterComposite = new Composite(parentComposite, 0);
        GridLayout filterCompositeGridLayout = new GridLayout(1, false);
        filterCompositeGridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        filterCompositeGridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        filterComposite.setLayout((Layout)filterCompositeGridLayout);
        filterComposite.setLayoutData((Object)new GridData(768));
        Label filterLabel = new Label(filterComposite, 0);
        filterLabel.setText(ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.DIALOGS.FILTERLISTSELECTIONDIALOG.FILTERLABEL"));
        this.filterText = new Text(filterComposite, 2052);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FilterListSelectionDialog.this.refreshFilter(FilterListSelectionDialog.this.filterText.getText());
            }
        });
        super.createDialogArea(parentComposite);
        return parentComposite;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilterListSelectionDialog.this.setCheckedState(FilterListSelectionDialog.this.getTreeViewer(), event.getElement());
            }
        });
        return treeViewer;
    }

    private void setCheckedState(CheckboxTreeViewer treeViewer, Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        if (contentProvider.hasChildren(element)) {
            Iterator childrenIterator = this.getAllChildren(element, contentProvider, treeViewer.getFilters()).iterator();
            while (childrenIterator.hasNext()) {
                Object child = childrenIterator.next();
                if (treeViewer.getChecked(child)) {
                    this.checkedItems.add(child);
                    continue;
                }
                this.checkedItems.remove(child);
            }
        } else if (treeViewer.getChecked(element)) {
            this.checkedItems.add(element);
        } else {
            this.checkedItems.remove(element);
        }
    }

    private List getAllChildren(Object element, ITreeContentProvider contentProvider, ViewerFilter[] filters) {
        if (contentProvider.hasChildren(element)) {
            Object[] children = this.filterElements(contentProvider.getChildren(element), element, filters);
            ArrayList childrenList = new ArrayList(children.length);
            int i = 0;
            while (i < children.length) {
                childrenList.addAll(this.getAllChildren(children[i], contentProvider, filters));
                ++i;
            }
            return childrenList;
        }
        return Collections.singletonList(element);
    }

    private Object[] filterElements(Object[] elements, Object parent, ViewerFilter[] filters) {
        Object[] filteredElements = elements;
        int i = 0;
        while (i < filters.length) {
            filteredElements = filters[i].filter((Viewer)this.getTreeViewer(), parent, filteredElements);
            ++i;
        }
        return filteredElements;
    }

    private void refreshFilter(String filterString) {
        ListSelectionFilter filter = (ListSelectionFilter)this.getTreeViewer().getFilters()[0];
        filter.setFilter(filterString);
        this.getTreeViewer().refresh();
        this.getTreeViewer().setCheckedElements(this.checkedItems.toArray());
    }

    public static class ListSelectionFilter
    extends ViewerFilter {
        private Pattern filter;

        public boolean isElementFilterable(Viewer viewer, Object parentElement, Object element) {
            return true;
        }

        public final boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.isElementFilterable(viewer, parentElement, element)) {
                return true;
            }
            if (!(element instanceof ENamedElement)) {
                return false;
            }
            return this.filter == null || this.filter.matcher(((ENamedElement)element).getName()).matches();
        }

        void setFilter(String filterString) {
            if (filterString == null || filterString.equals("")) {
                this.filter = null;
            } else {
                String filterPattern = filterString.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\.", "\\\\.").replaceAll("\\?", ".").replaceAll("\\*", ".*");
                this.filter = Pattern.compile(filterPattern, 66);
            }
        }
    }
}

