/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.ConnectionProfileProperty;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.Relationship;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.TraceLogging;

public class ExtensionManifest {
    public static final String CLASS_ATTRIBUTE_NAME = "driverClass";
    private String m_namespace;
    private String m_dataSourceElementId;
    private String m_odaVersion;
    private String m_displayName;
    private RuntimeInterface m_runtime;
    private Hashtable m_dataSetTypes;
    private TraceLogging m_traceLogging;
    private Property[] m_extensionDefinedProperties = null;
    private Property[] m_properties = null;
    private Properties m_propsVisibility;
    private IConfigurationElement m_dataSourceElement;
    private IExtension m_dataSourceExtn;
    private List m_relationships;

    ExtensionManifest(IExtension dataSourceExtn) throws OdaException {
        this.init(dataSourceExtn);
    }

    protected ExtensionManifest() {
    }

    protected void init(IExtension dataSourceExtn) throws OdaException {
        IConfigurationElement[] propertiesElements;
        this.m_dataSourceElement = ManifestExplorer.getDataSourceElement(dataSourceExtn);
        assert (this.m_dataSourceElement != null);
        this.m_namespace = dataSourceExtn.getContributor().getName();
        this.m_dataSourceElementId = this.m_dataSourceElement.getAttribute("id");
        if (this.m_dataSourceElementId == null || this.m_dataSourceElementId.length() == 0) {
            throw new OdaException(Messages.manifest_NO_DATA_SOURCE_EXTN_ID_DEFINED);
        }
        this.m_odaVersion = this.m_dataSourceElement.getAttribute("odaVersion");
        this.m_displayName = ManifestExplorer.getElementDisplayName(this.m_dataSourceElement);
        String driverClass = this.m_dataSourceElement.getAttribute(CLASS_ATTRIBUTE_NAME);
        if (driverClass == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_DRIVER_CLASS_DEFINED, (Object)this.m_dataSourceElementId));
        }
        String needSetThreadContextClassLoader = this.m_dataSourceElement.getAttribute("setThreadContextClassLoader");
        if (needSetThreadContextClassLoader == null || needSetThreadContextClassLoader.length() == 0) {
            needSetThreadContextClassLoader = "false";
        } else if (!needSetThreadContextClassLoader.equalsIgnoreCase("true") && !needSetThreadContextClassLoader.equalsIgnoreCase("false")) {
            throw new OdaException(Messages.bind((String)Messages.manifest_INVALID_SET_THREAD_CONTEXT_CLASSLOADER_VALUE, (Object)needSetThreadContextClassLoader, (Object)this.m_dataSourceElementId));
        }
        this.m_runtime = new JavaRuntimeInterface(driverClass, Boolean.valueOf(needSetThreadContextClassLoader), this.m_namespace);
        this.m_dataSetTypes = ManifestExplorer.getDataSetElements(dataSourceExtn, this.m_dataSourceElementId);
        IConfigurationElement[] traceLogging = this.m_dataSourceElement.getChildren("traceLogging");
        int numOfTraceLogging = traceLogging.length;
        if (numOfTraceLogging > 0) {
            this.m_traceLogging = new TraceLogging(traceLogging[numOfTraceLogging - 1], this.m_dataSourceElementId);
        }
        if ((propertiesElements = this.m_dataSourceElement.getChildren("properties")).length > 0) {
            IConfigurationElement propertiesElement = propertiesElements[propertiesElements.length - 1];
            ArrayList extensionProps = ExtensionManifest.getPropertyDefinitions(propertiesElement);
            this.m_extensionDefinedProperties = extensionProps.toArray(new Property[extensionProps.size()]);
            this.m_properties = this.addDataSourceFrameworkProperties(extensionProps);
            this.m_propsVisibility = ExtensionManifest.getPropertyVisibilities(propertiesElement);
        }
        this.m_relationships = Relationship.createInstances(this.m_dataSourceElement);
        this.m_dataSourceExtn = dataSourceExtn;
    }

    protected IExtension getDataSourceExtension() {
        return this.m_dataSourceExtn;
    }

    static ArrayList getPropertyDefinitions(IConfigurationElement propertiesElement) throws OdaException {
        IConfigurationElement[] propElements = propertiesElement.getChildren("property");
        IConfigurationElement[] propGroupElements = propertiesElement.getChildren("propertyGroup");
        int numProperties = propElements.length + propGroupElements.length;
        ArrayList<Property> properties = new ArrayList<Property>();
        if (numProperties <= 0) {
            return properties;
        }
        int i = 0;
        int size = propElements.length;
        while (i < size) {
            IConfigurationElement propElement = propElements[i];
            properties.add(new Property(propElement));
            ++i;
        }
        int j = 0;
        int size2 = propGroupElements.length;
        while (j < size2) {
            IConfigurationElement propGroupElement = propGroupElements[j];
            String groupName = propGroupElement.getAttribute("name");
            String groupDisplayName = ManifestExplorer.getElementDisplayName(propGroupElement);
            IConfigurationElement[] groupedPropElements = propGroupElement.getChildren("property");
            int i2 = 0;
            int size3 = groupedPropElements.length;
            while (i2 < size3) {
                IConfigurationElement groupedPropElement = groupedPropElements[i2];
                properties.add(new Property(groupedPropElement, groupName, groupDisplayName));
                ++i2;
            }
            ++j;
        }
        return properties;
    }

    private Property[] addDataSourceFrameworkProperties(ArrayList propDefinitions) {
        if (propDefinitions == null) {
            propDefinitions = new ArrayList<Property>();
        }
        if (!ExtensionManifest.containsProperty("OdaConnProfileName", propDefinitions)) {
            propDefinitions.add(ConnectionProfileProperty.createPropertyDefinition("OdaConnProfileName"));
        }
        if (!ExtensionManifest.containsProperty("OdaConnProfileStorePath", propDefinitions)) {
            propDefinitions.add(ConnectionProfileProperty.createPropertyDefinition("OdaConnProfileStorePath"));
        }
        return propDefinitions.toArray(new Property[propDefinitions.size()]);
    }

    private static boolean containsProperty(String propertyName, ArrayList properties) {
        if (properties.isEmpty()) {
            return false;
        }
        for (Property aProp : properties) {
            if (aProp == null || !propertyName.equals(aProp.getName())) continue;
            return true;
        }
        return false;
    }

    static Properties getPropertyVisibilities(IConfigurationElement propertiesElement) throws OdaException {
        IConfigurationElement[] propVisibilityElements = propertiesElement.getChildren("propertyVisibility");
        if (propVisibilityElements.length == 0) {
            return null;
        }
        Properties propsVisibility = new Properties();
        int i = 0;
        int size = propVisibilityElements.length;
        while (i < size) {
            IConfigurationElement propVisibltyElement = propVisibilityElements[i];
            String propName = propVisibltyElement.getAttribute("name");
            String propVisbility = propVisibltyElement.getAttribute("visibility");
            propsVisibility.setProperty(propName, propVisbility);
            ++i;
        }
        return propsVisibility;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getExtensionID() {
        return this.getDataSourceElementID();
    }

    public String getDataSourceElementID() {
        return this.m_dataSourceElementId;
    }

    public IConfigurationElement getDataSourceElement() {
        return this.m_dataSourceElement;
    }

    public URL getDriverLocation() throws IOException {
        return this.m_runtime.getLibraryLocation();
    }

    public String getOdaVersion() {
        return this.m_odaVersion;
    }

    public String getDataSourceDisplayName() {
        return this.m_displayName;
    }

    public DataSetType[] getDataSetTypes() {
        Collection dataSetTypes = this.m_dataSetTypes.values();
        int size = dataSetTypes.size();
        return dataSetTypes.toArray(new DataSetType[size]);
    }

    public String[] getDataSetTypeIDs() {
        Set dataSetTypeIDs = this.m_dataSetTypes.keySet();
        int size = dataSetTypeIDs.size();
        return dataSetTypeIDs.toArray(new String[size]);
    }

    public int getDataSetTypeCount() {
        return this.m_dataSetTypes.size();
    }

    public DataSetType getDataSetType(String dataSetElementID) throws OdaException {
        if (dataSetElementID == null) {
            if (this.m_dataSetTypes.size() != 1) {
                this.throwsIllegalArgumentOdaException(dataSetElementID);
            }
            Collection dataSetTypes = this.m_dataSetTypes.values();
            assert (dataSetTypes.size() == 1);
            return (DataSetType)dataSetTypes.toArray()[0];
        }
        DataSetType dsType = (DataSetType)this.m_dataSetTypes.get(dataSetElementID);
        if (dsType == null) {
            this.throwsIllegalArgumentOdaException(dataSetElementID);
        }
        return dsType;
    }

    private void throwsIllegalArgumentOdaException(String arg) throws OdaException {
        IllegalArgumentException illegalArg = new IllegalArgumentException(arg);
        OdaException ex = new OdaException(illegalArg.toString());
        ex.initCause(illegalArg);
        throw ex;
    }

    public TraceLogging getTraceLogging() {
        return this.m_traceLogging;
    }

    public RuntimeInterface getRuntimeInterface() {
        return this.m_runtime;
    }

    public Property[] getProperties() {
        return this.getProperties(true);
    }

    public Property[] getProperties(boolean includeInheritedProps) {
        Property[] props;
        Property[] propertyArray = props = includeInheritedProps ? this.m_properties : this.m_extensionDefinedProperties;
        if (props == null) {
            props = new Property[]{};
        }
        return props;
    }

    public Property[] getVisibleProperties() {
        return ManifestUtil.getVisiblePropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property[] getHiddenProperties() {
        return ManifestUtil.getHiddenPropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property getProperty(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        Property[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            if (propertyName.equals(props[i].getName())) {
                return props[i];
            }
            ++i;
        }
        return null;
    }

    public Properties getPropertiesVisibility() {
        if (this.m_propsVisibility == null) {
            this.m_propsVisibility = new Properties();
        }
        return this.m_propsVisibility;
    }

    public boolean isDeprecated() {
        List replacedBy = this.getRelationships(1);
        return replacedBy != null && !replacedBy.isEmpty();
    }

    public boolean isWrapper() {
        List wrappersOf = this.getRelationships(2);
        return wrappersOf != null && !wrappersOf.isEmpty();
    }

    public String getRelatedDataSourceId() {
        List relationships = this.getRelationships(1);
        if (relationships == null) {
            return null;
        }
        Relationship replacedBy = (Relationship)relationships.get(0);
        return replacedBy != null ? replacedBy.getRelatedId() : null;
    }

    public List getRelationships(int relationshipType) {
        if (this.m_relationships == null || this.m_relationships.isEmpty()) {
            return null;
        }
        Vector<Relationship> matchingRelationships = new Vector<Relationship>(this.m_relationships.size());
        for (Relationship aRelationship : this.m_relationships) {
            if (aRelationship.getType() != relationshipType) continue;
            matchingRelationships.add(aRelationship);
        }
        return matchingRelationships.isEmpty() ? null : matchingRelationships;
    }
}

