/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class ConnectionProfileProperty {
    public static final String PROFILE_NAME_PROP_KEY = "OdaConnProfileName";
    public static final String PROFILE_STORE_FILE_PATH_PROP_KEY = "OdaConnProfileStorePath";
    public static final String PROFILE_STORE_FILE_PROP_KEY = "OdaConnProfileStore";
    private static final String PROPERTY_GROUP_NAME = "ConnectionProfileProperties";

    static Property createPropertyDefinition(String propertyName) {
        assert (propertyName != null);
        assert (propertyName == PROFILE_NAME_PROP_KEY || propertyName == PROFILE_STORE_FILE_PATH_PROP_KEY);
        String propDisplayName = ConnectionProfileProperty.getPropertyDisplayName(propertyName);
        String groupDisplayName = ConnectionProfileProperty.getPropertyDisplayName(PROPERTY_GROUP_NAME);
        Property newProp = new Property(propertyName, propDisplayName, PROPERTY_GROUP_NAME, groupDisplayName);
        if (propertyName == PROFILE_NAME_PROP_KEY) {
            newProp.setAllowsEmptyValueAsNull(false);
        }
        return newProp;
    }

    private static String getPropertyDisplayName(String propertyName) {
        if (propertyName == PROFILE_NAME_PROP_KEY) {
            return Messages.profileProperty_PROFILE_NAME;
        }
        if (propertyName == PROFILE_STORE_FILE_PATH_PROP_KEY) {
            return Messages.profileProperty_PROFILE_STORE_PATH;
        }
        if (propertyName == PROPERTY_GROUP_NAME) {
            return Messages.profileProperty_GROUP_PROPERTIES;
        }
        return propertyName;
    }
}

