/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.manifest.AggregateDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.manifest.SupportedDataSetType;
import org.eclipse.datatools.connectivity.oda.spec.result.AggregateExpression;

public class CustomAggregate
extends AggregateExpression
implements IExecutableExtension {
    private static final String QUALIFER_SEPARATOR = ".";
    private String m_id;
    private String m_extensionId;
    private Map<String, Object> m_customData;
    private AggregateDefinition m_definition;

    public CustomAggregate(String extensionId, String id, ExpressionVariable inputSourceVar) {
        super(inputSourceVar);
        this.m_extensionId = extensionId;
        this.m_id = id;
    }

    public CustomAggregate(String extensionId, String id) {
        this(extensionId, id, null);
    }

    public CustomAggregate() {
        super(null);
    }

    public void setInitializationData(IConfigurationElement exprElement, String propertyName, Object data) throws CoreException {
        this.m_extensionId = exprElement.getDeclaringExtension().getUniqueIdentifier();
        try {
            this.m_id = AggregateDefinition.getIdAttributeValue(exprElement);
        }
        catch (OdaException ex) {
            throw new CoreException((IStatus)new Status(4, exprElement.getContributor().getName(), ex.getLocalizedMessage()));
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String getDeclaringExtensionId() {
        return this.m_extensionId;
    }

    public String getQualifiedId() {
        return String.valueOf(this.m_extensionId) + QUALIFER_SEPARATOR + this.m_id;
    }

    public String getAlias() {
        if (this.getDefinition() == null) {
            return super.getAlias();
        }
        StringBuffer alias = new StringBuffer(this.getDefinition().getDisplayName());
        alias.append("_");
        alias.append(super.getAlias());
        return alias.toString();
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        AggregateDefinition defn = this.getDefinition();
        if (defn == null) {
            return false;
        }
        return defn.supportsDataSetType(odaDataSourceId, odaDataSetId);
    }

    public boolean supportsDataSetType(SupportedDataSetType dataSetType) {
        if (dataSetType == null) {
            return false;
        }
        return this.supportsDataSetType(dataSetType.getOdaDataSourceId(), dataSetType.getOdaDataSetId());
    }

    public boolean canIgnoreDuplicateValues() {
        AggregateDefinition defn = this.getDefinition();
        return defn == null ? false : defn.canIgnoreDuplicateValues();
    }

    public boolean canIgnoreNullValues() {
        AggregateDefinition defn = this.getDefinition();
        return defn == null ? false : defn.canIgnoreNullValues();
    }

    public AggregateDefinition getDefinition() {
        if (this.m_definition == null) {
            try {
                this.m_definition = ResultExtensionExplorer.getInstance().getExtensionAggregateDefinition(this.getDeclaringExtensionId(), this.getId());
            }
            catch (OdaException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return this.m_definition;
    }

    public Object getData(String key) {
        if (this.m_customData == null) {
            return null;
        }
        return this.m_customData.get(key);
    }

    public void setData(String key, Object value) {
        if (this.m_customData == null) {
            this.m_customData = new HashMap<String, Object>();
        }
        this.m_customData.put(key, value);
    }

    public void validate(ValidationContext context) throws OdaException {
        AggregateDefinition defn = this.getDefinition();
        if (defn == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_NON_DEFINED_CUSTOM_AGGR, (Object)this.getDeclaringExtensionId(), (Object)this.getQualifiedId()));
        }
        this.validate(context, defn);
    }

    protected void validate(ValidationContext context, AggregateDefinition defn) throws OdaException {
        assert (defn != null);
        if (this.ignoresDuplicateValues() && !defn.canIgnoreDuplicateValues()) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_CUSTOM_AGGR_INCOMPATIBLE_DUPL_CHECK, (Object)this.getQualifiedId()));
        }
        if (this.ignoresNullValues() && !defn.canIgnoreNullValues()) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_CUSTOM_AGGR_INCOMPATIBLE_NULL_CHECK, (Object)this.getQualifiedId()));
        }
        IValidator customValidator = this.getValidator(context);
        if (customValidator != null) {
            customValidator.validate(this, context);
        }
    }

    protected IValidator getValidator(ValidationContext context) {
        if (context != null && context.getValidator() != null) {
            return context.getValidator();
        }
        try {
            if (this.getDefinition() != null) {
                return this.getDefinition().getValidator();
            }
        }
        catch (OdaException odaException) {}
        return null;
    }
}

