/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

public class ManifestExplorer {
    private static ManifestExplorer sm_instance = null;
    private static String sm_loggerName;
    private static Logger sm_logger;
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";

    public static ManifestExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new ManifestExplorer();
            sm_loggerName = sm_instance.getClass().getPackage().getName();
            sm_logger = Logger.getLogger(sm_loggerName);
        }
        return sm_instance;
    }

    private ManifestExplorer() {
    }

    public Properties getDataSourceIdentifiers() {
        IExtension[] extensions = this.getDataSourceExtensions();
        int length = extensions == null ? 0 : extensions.length;
        Properties extensionIds = new Properties();
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                IConfigurationElement dsElement = ManifestExplorer.getDataSourceElement(extension);
                String dataSourceId = dsElement.getAttribute("id");
                String dataSourceDisplayName = ManifestExplorer.getElementDisplayName(dsElement);
                extensionIds.setProperty(dataSourceId, dataSourceDisplayName);
                continue;
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        return extensionIds;
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId) throws OdaException {
        ExtensionManifest manifest = this.getExtensionManifest(dataSourceId, DTP_ODA_EXT_POINT);
        if (manifest != null) {
            return manifest;
        }
        throw new IllegalArgumentException(dataSourceId);
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId, String extensionPoint) throws OdaException {
        if (dataSourceId == null || dataSourceId.length() == 0) {
            throw new IllegalArgumentException(dataSourceId);
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new IllegalArgumentException(extensionPoint);
        }
        IExtension[] extensions = ManifestExplorer.getExtensions(extensionPoint);
        IExtension extension = this.findExtension(dataSourceId, extensions);
        if (extension != null) {
            return this.newExtensionManifest(extension);
        }
        return null;
    }

    ExtensionManifest newExtensionManifest(IExtension platformExtension) throws OdaException {
        if (platformExtension == null) {
            throw new IllegalArgumentException(Messages.manifest_nullArgument);
        }
        return new ExtensionManifest(platformExtension);
    }

    public ExtensionManifest[] getExtensionManifests() {
        return this.getExtensionManifests(false);
    }

    public ExtensionManifest[] getExtensionManifests(boolean includesAllExtensions) {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT, includesAllExtensions);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint) {
        return this.getExtensionManifests(extensionPoint, false);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint, boolean includesAllExtensions) {
        IExtension[] extensions = ManifestExplorer.getExtensions(extensionPoint);
        int length = extensions == null ? 0 : extensions.length;
        ArrayList<ExtensionManifest> manifestList = new ArrayList<ExtensionManifest>(length);
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                ExtensionManifest manifest = this.newExtensionManifest(extension);
                if (!includesAllExtensions && manifest.getDataSetTypeCount() <= 0) continue;
                manifestList.add(manifest);
                continue;
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        int numOfValidExtensions = manifestList.size();
        return manifestList.toArray(new ExtensionManifest[numOfValidExtensions]);
    }

    private IExtension findExtension(String dataSourceId, IExtension[] extensions) throws OdaException {
        int length = extensions == null ? 0 : extensions.length;
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            String extnDataSourceId = null;
            try {
                IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(extension);
                extnDataSourceId = dataSourceElement.getAttribute("id");
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
                continue;
            }
            if (extnDataSourceId == null || !extnDataSourceId.equalsIgnoreCase(dataSourceId)) continue;
            return extension;
        }
        return null;
    }

    private IExtension[] getDataSourceExtensions() {
        return ManifestExplorer.getExtensions(DTP_ODA_EXT_POINT);
    }

    public static IExtension[] getExtensions(String extPoint) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(extPoint);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getExtensions();
    }

    static IConfigurationElement getDataSourceElement(IExtension extension) throws OdaException {
        return ManifestExplorer.getNamedElement(extension, "dataSource");
    }

    public static IConfigurationElement getNamedElement(IExtension extension, String elementName) throws OdaException {
        IConfigurationElement[] configElements = ManifestExplorer.getNamedElements(extension, elementName);
        if (configElements.length == 0) {
            throw new OdaException(Messages.manifest_NO_DRIVER_RUNTIME_CONFIGURATION_DEFINED);
        }
        return configElements[0];
    }

    public static IConfigurationElement[] getNamedElements(IExtension extension, String elementName) throws OdaException {
        return ManifestExplorer.getNamedElements(extension, elementName, "id");
    }

    public static IConfigurationElement[] getNamedElements(IExtension extension, String elementName, String requiredAttributeName) throws OdaException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        ArrayList<IConfigurationElement> matchedElements = new ArrayList<IConfigurationElement>();
        int n = configElements.length;
        for (int i = 0; i < n; ++i) {
            IConfigurationElement configElement = configElements[i];
            if (!configElement.getName().equalsIgnoreCase(elementName)) continue;
            String attrValue = configElement.getAttribute(requiredAttributeName);
            if (attrValue == null || attrValue.length() == 0) {
                throw new OdaException(Messages.bind((String)Messages.manifest_NO_ATTRIBUTE_ID_DEFINED, (Object)requiredAttributeName, (Object)elementName));
            }
            matchedElements.add(configElement);
        }
        return matchedElements.toArray(new IConfigurationElement[matchedElements.size()]);
    }

    static Hashtable getDataSetElements(IExtension extension, String dataSourceElementId) throws OdaException {
        IConfigurationElement[] configElements = ManifestExplorer.getNamedElements(extension, "dataSet");
        Hashtable<String, DataSetType> dataSetElements = new Hashtable<String, DataSetType>();
        int numConfigElements = configElements.length;
        for (int i = 0; i < numConfigElements; ++i) {
            IConfigurationElement configElement = configElements[i];
            String dataSetTypeId = configElement.getAttribute("id");
            dataSetElements.put(dataSetTypeId, new DataSetType(configElement));
        }
        if (dataSetElements.size() < 1) {
            String msg = Messages.bind((String)Messages.manifest_NO_DATA_SET_TYPES_DEFINED, (Object)dataSourceElementId);
            if (numConfigElements >= 1) {
                throw new OdaException(msg);
            }
            sm_logger.log(Level.INFO, msg);
        }
        return dataSetElements;
    }

    static String getElementDisplayName(IConfigurationElement dsElement) {
        String displayName = dsElement.getAttribute("defaultDisplayName");
        if ((displayName == null || displayName.length() == 0) && (displayName = dsElement.getAttribute("name")) == null) {
            displayName = dsElement.getAttribute("id");
        }
        return displayName;
    }
}

