/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileDriver;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.util.Utility;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.ColumnsInfoUtil;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.QueryTextUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class FileSelectionWizardPage
extends DataSetWizardPage
implements ISelectionChangedListener {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFile");
    private static final String ALL_CSV_EXTENSION = "*.csv";
    private static final String CSV_EXTENSION = ".csv";
    private static final String ALL_SSV_EXTENSION = "*.ssv";
    private static final String SSV_EXTENSION = ".ssv";
    private static final String ALL_TSV_EXTENSION = "*.tsv";
    private static final String TSV_EXTENSION = ".tsv";
    private static final String ALL_PSV_EXTENSION = "*.psv";
    private static final String PSV_EXTENSION = ".psv";
    private static final String ALL_TXT_EXTENSION = "*.txt";
    private static final String TXT_EXTENSION = ".txt";
    private static final String MATCH_ALL_FILES = "*.*";
    private static final String queryTextDelimiter = ":";
    private static final String columnsInfoStartSymbol = "{";
    private static final String columnsInfoEndSymbol = "}";
    private static String name = Messages.getString("editor.title.name");
    private static String originalName = Messages.getString("editor.title.originalName");
    private static String dataType = Messages.getString("editor.title.type");
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};
    private HashMap dataTypeDisplayNameMap = new HashMap();
    private HashMap dataTypeValueMape = new HashMap();
    private final int DEFAULT_WIDTH = 200;
    private final int DEFAULT_HEIGHT = 200;
    private transient ComboViewer fileViewer = null;
    private transient ComboViewer fileFilter = null;
    private transient org.eclipse.swt.widgets.List availableList = null;
    private transient TableViewer selectedColumnsViewer = null;
    private transient Button btnAdd = null;
    private transient Button btnRemove = null;
    private transient Button btnMoveUp = null;
    private transient Button btnMoveDown = null;
    private boolean initialized = true;
    private String odaHome;
    private String charSet = null;
    private String inclColumnNameLine;
    private String flatfileDelimiterType;
    private String inclTypeLine;
    private String savedSelectedColumnsInfoString;
    private String selectedFileFilter;
    private File selectedFile;
    private String nameOfFileWithErrorInLastAccess = null;
    private List originalFileColumnsInfoList = new ArrayList();
    private List savedSelectedColumnsInfoList = new ArrayList();

    public FileSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.createColumnTypeMap();
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public FileSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Dialog_SelectTableColumn_ID");
    }

    private void createColumnTypeMap() {
        this.dataTypeDisplayNameMap.put(new Integer(4), Messages.getString("datatypes.integer"));
        this.dataTypeDisplayNameMap.put(new Integer(8), Messages.getString("datatypes.float"));
        this.dataTypeDisplayNameMap.put(new Integer(12), Messages.getString("datatypes.string"));
        this.dataTypeDisplayNameMap.put(new Integer(91), Messages.getString("datatypes.date"));
        this.dataTypeDisplayNameMap.put(new Integer(92), Messages.getString("datatypes.time"));
        this.dataTypeDisplayNameMap.put(new Integer(93), Messages.getString("datatypes.dateTime"));
        this.dataTypeDisplayNameMap.put(new Integer(2), Messages.getString("datatypes.decimal"));
        this.dataTypeDisplayNameMap.put(new Integer(16), Messages.getString("datatypes.boolean"));
        this.dataTypeValueMape.put(Messages.getString("datatypes.integer"), "INT");
        this.dataTypeValueMape.put(Messages.getString("datatypes.float"), "DOUBLE");
        this.dataTypeValueMape.put(Messages.getString("datatypes.string"), "STRING");
        this.dataTypeValueMape.put(Messages.getString("datatypes.date"), "DATE");
        this.dataTypeValueMape.put(Messages.getString("datatypes.time"), "TIME");
        this.dataTypeValueMape.put(Messages.getString("datatypes.dateTime"), "TIMESTAMP");
        this.dataTypeValueMape.put(Messages.getString("datatypes.decimal"), "BIGDECIMAL");
        this.dataTypeValueMape.put(Messages.getString("datatypes.boolean"), "BOOLEAN");
    }

    private void initializeControl() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null) {
            return;
        }
        this.updateValuesFromQuery(queryText);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.fileViewer == null) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectFile"));
        label.setLayoutData((Object)data);
        this.createTopComposite(composite, label);
        this.createLeftComposite(composite);
        Composite btnComposite = this.createAddBtnComposite(composite);
        this.createRightComposite(composite, btnComposite);
        this.setupEditors();
        this.loadProperties();
        this.populateFileFilter();
        this.updateFileListAndCharSet();
        return composite;
    }

    private void createTopComposite(Composite composite, Label label) {
        final Shell shell = composite.getShell();
        FormData data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(80, -5);
        this.fileViewer = new ComboViewer(composite, 2056);
        this.fileViewer.getControl().setLayoutData((Object)data);
        this.fileViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((File)element).getName();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(this.fileViewer.getControl(), 5);
        data.top = new FormAttachment(0, 5);
        label = new Label(composite, 0);
        label.setText(Messages.getString("label.fileFilter"));
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(100, -5);
        this.fileFilter = new ComboViewer(composite, 8);
        this.fileFilter.getControl().setLayoutData((Object)data);
        this.fileFilter.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String currSelectFilter = FileSelectionWizardPage.this.fileFilter.getCombo().getText();
                if (currSelectFilter.equalsIgnoreCase(FileSelectionWizardPage.this.selectedFileFilter)) {
                    return;
                }
                if (!FileSelectionWizardPage.this.initialized) {
                    FileSelectionWizardPage.this.selectedFileFilter = currSelectFilter;
                    FileSelectionWizardPage.this.updateFileListAndCharSet();
                    FileSelectionWizardPage.this.initialized = true;
                } else if (currSelectFilter.equals(FileSelectionWizardPage.MATCH_ALL_FILES) || MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("confirm.reselectFileFilterTitle"), (String)Messages.getString("confirm.reselectFileFilterMessage"))) {
                    FileSelectionWizardPage.this.selectedFileFilter = currSelectFilter;
                    FileSelectionWizardPage.this.updateFileListAndCharSet();
                } else {
                    FileSelectionWizardPage.this.fileFilter.getCombo().setText(FileSelectionWizardPage.this.selectedFileFilter);
                }
            }
        });
    }

    private void createLeftComposite(Composite composite) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.fileViewer.getControl(), 10, 1024);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(40, -5);
        data.bottom = new FormAttachment(100, -5);
        data.width = 200;
        data.height = 200;
        this.availableList = new org.eclipse.swt.widgets.List(composite, 2818);
        this.availableList.setLayoutData((Object)data);
        this.availableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.selectedColumnsViewer.getTable().deselectAll();
                FileSelectionWizardPage.this.btnAdd.setEnabled(true);
                FileSelectionWizardPage.this.btnRemove.setEnabled(false);
                FileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                FileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
            }
        });
        this.availableList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileSelectionWizardPage.this.addColumns();
            }
        });
    }

    private Composite createAddBtnComposite(Composite composite) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, 5);
        data.left = new FormAttachment((Control)this.availableList, 3);
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        btnComposite.setLayout((Layout)layout);
        this.btnAdd = new Button(btnComposite, 0);
        GridData gridData = new GridData(772);
        gridData.heightHint = 25;
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnAdd.setToolTipText(Messages.getString("tooltip.button.add"));
        if (this.btnAdd.getStyle() == (this.btnAdd.getStyle() | 0x2000000)) {
            this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        } else {
            this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.addColumns();
            }
        });
        return btnComposite;
    }

    private void createRightComposite(Composite composite, Composite btnComposite) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.fileViewer.getControl(), 10, 1024);
        data.left = new FormAttachment((Control)btnComposite, 3);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -5);
        Composite rightComposite = new Composite(composite, 2048);
        rightComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rightComposite.setLayout((Layout)layout);
        this.selectedColumnsViewer = new TableViewer(rightComposite, 68354);
        this.selectedColumnsViewer.getTable().setHeaderVisible(true);
        this.selectedColumnsViewer.getTable().setLinesVisible(true);
        this.selectedColumnsViewer.getTable().setLayoutData((Object)new GridData(1808));
        TableColumn column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.originalName"));
        column.setWidth(100);
        column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.type"));
        column.setWidth(100);
        this.selectedColumnsViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.btnAdd.setEnabled(false);
                FileSelectionWizardPage.this.availableList.deselectAll();
                int count = FileSelectionWizardPage.this.selectedColumnsViewer.getTable().getSelectionCount();
                int index = FileSelectionWizardPage.this.selectedColumnsViewer.getTable().getSelectionIndex();
                if (count == 1) {
                    FileSelectionWizardPage.this.btnRemove.setEnabled(true);
                    if (index == 0) {
                        FileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                        FileSelectionWizardPage.this.btnMoveDown.setEnabled(true);
                    } else if (index == FileSelectionWizardPage.this.selectedColumnsViewer.getTable().getItemCount() - 1) {
                        FileSelectionWizardPage.this.btnMoveUp.setEnabled(true);
                        FileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                    } else {
                        FileSelectionWizardPage.this.btnMoveUp.setEnabled(true);
                        FileSelectionWizardPage.this.btnMoveDown.setEnabled(true);
                    }
                } else if (count > 1) {
                    FileSelectionWizardPage.this.btnRemove.setEnabled(true);
                    FileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                    FileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                } else {
                    FileSelectionWizardPage.this.btnRemove.setEnabled(false);
                    FileSelectionWizardPage.this.btnMoveUp.setEnabled(false);
                    FileSelectionWizardPage.this.btnMoveDown.setEnabled(false);
                }
            }
        });
        this.setColumnsViewerContent();
        this.setColumnsViewerLabels();
        this.selectedColumnsViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileSelectionWizardPage.this.removeColumns();
            }
        });
        this.createEditBtnGroup(rightComposite);
    }

    private void createEditBtnGroup(Composite rightComposite) {
        Composite btnComposite = new Composite(rightComposite, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        btnComposite.setLayout((Layout)layout);
        this.btnMoveUp = new Button(btnComposite, 0);
        this.btnMoveUp.setText(Messages.getString("button.moveUp"));
        GridData btnMoveUpGd = new GridData();
        btnMoveUpGd.widthHint = 52;
        this.btnMoveUp.setLayoutData((Object)btnMoveUpGd);
        this.btnMoveUp.setToolTipText(Messages.getString("tooltip.button.up"));
        this.btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.moveUpItem();
            }
        });
        this.btnRemove = new Button(btnComposite, 0);
        this.btnRemove.setText(Messages.getString("button.delete"));
        GridData btnRemoveGd = new GridData(4);
        btnRemoveGd.widthHint = 52;
        this.btnRemove.setLayoutData((Object)btnRemoveGd);
        this.btnRemove.setToolTipText(Messages.getString("tooltip.button.delete"));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.removeColumns();
            }
        });
        this.btnMoveDown = new Button(btnComposite, 0);
        this.btnMoveDown.setText(Messages.getString("button.moveDown"));
        GridData btnMoveDownGd = new GridData();
        btnMoveDownGd.widthHint = 52;
        this.btnMoveDown.setLayoutData((Object)btnMoveDownGd);
        this.btnMoveDown.setToolTipText(Messages.getString("tooltip.button.down"));
        this.btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.moveDownItem();
            }
        });
    }

    private void setColumnsViewerLabels() {
        this.selectedColumnsViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((String[])element)[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void setColumnsViewerContent() {
        this.selectedColumnsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new TextCellEditor((Composite)this.selectedColumnsViewer.getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.selectedColumnsViewer.getTable(), dataTypeDisplayNames, 8);
        this.selectedColumnsViewer.setColumnProperties(new String[]{name, originalName, dataType});
        this.selectedColumnsViewer.setCellEditors(editors);
        this.selectedColumnsViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                if (name.equals(property)) {
                    value = ((String[])element)[0];
                } else if (originalName.equals(property)) {
                    value = ((String[])element)[1];
                } else if (dataType.equals(property)) {
                    String temp = ((String[])element)[2];
                    if (temp == null) {
                        value = new Integer(0);
                    } else {
                        int i = 0;
                        while (i < dataTypeDisplayNames.length) {
                            if (temp.equals(dataTypeDisplayNames[i])) {
                                value = new Integer(i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                String[] actualElement = (String[])((TableItem)element).getData();
                if (value != null) {
                    if (name.equals(property)) {
                        if (FileSelectionWizardPage.this.isUnique(actualElement, (String)value) && !FileSelectionWizardPage.this.isEmpty((String)value)) {
                            FileSelectionWizardPage.this.replace(actualElement, property, (String)value);
                            FileSelectionWizardPage.this.selectedColumnsViewer.refresh();
                            FileSelectionWizardPage.this.setMessage(DEFAULT_MESSAGE);
                        } else {
                            FileSelectionWizardPage.this.setMessage(Messages.getString("error.duplicatedNameValueOrEmpty"), 2);
                        }
                    } else if (dataType.equals(property)) {
                        int index = (Integer)value;
                        if (!dataTypeDisplayNames[index].equals(actualElement[2])) {
                            FileSelectionWizardPage.this.replace(actualElement, property, dataTypeDisplayNames[index]);
                            FileSelectionWizardPage.this.selectedColumnsViewer.refresh();
                        }
                    }
                    return;
                }
            }
        });
    }

    private boolean isUnique(String[] element, String value) {
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            if (i != this.savedSelectedColumnsInfoList.indexOf(element) && value.equalsIgnoreCase(((String[])this.savedSelectedColumnsInfoList.get(i))[0])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEmpty(String value) {
        return value.trim().equals("");
    }

    private int getExistenceCount(String columnName) {
        int count = 0;
        ArrayList existedColumns = new ArrayList();
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            if (columnName.equals(((String[])this.savedSelectedColumnsInfoList.get(i))[1])) {
                ++count;
                existedColumns.add(this.savedSelectedColumnsInfoList.get(i));
            }
            ++i;
        }
        int j = 0;
        while (j < existedColumns.size()) {
            if ((String.valueOf(columnName) + "_" + count).equals(((String[])this.savedSelectedColumnsInfoList.get(j))[0])) {
                ++count;
                j = -1;
            }
            ++j;
        }
        return count;
    }

    private void replace(String[] element, String property, String value) {
        int index = this.savedSelectedColumnsInfoList.indexOf(element);
        if (name.equals(property)) {
            element[0] = value;
            this.savedSelectedColumnsInfoList.set(index, element);
        } else if (dataType.equals(property)) {
            element[2] = value;
            this.savedSelectedColumnsInfoList.set(index, element);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
        if (file.equals(this.selectedFile)) {
            return;
        }
        this.selectedFile = file;
        this.setPageComplete(false);
        this.selectedColumnsViewer.getTable().removeAll();
        this.savedSelectedColumnsInfoList.clear();
        this.availableList.removeAll();
        this.nameOfFileWithErrorInLastAccess = null;
        String fileName = file.getName();
        String[] columnNames = this.getFileColumnNames(file);
        if (columnNames != null && columnNames.length != 0) {
            this.enableListAndViewer();
            this.availableList.setItems(columnNames);
            this.availableList.select(0);
            this.btnRemove.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            if (!(fileName.endsWith(CSV_EXTENSION) || fileName.endsWith(TXT_EXTENSION) || fileName.endsWith(SSV_EXTENSION) || fileName.endsWith(TSV_EXTENSION) || fileName.endsWith(PSV_EXTENSION))) {
                this.setMessage(Messages.getString("warning.fileExtensionInvalid"), 2);
            } else {
                this.setMessage(DEFAULT_MESSAGE);
            }
        }
    }

    private void loadProperties() {
        File cpFile;
        Properties dataSourceProps = null;
        try {
            dataSourceProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            return;
        }
        String sourcePath = dataSourceProps.getProperty("OdaConnProfileStorePath");
        if (sourcePath != null && !(cpFile = new File(sourcePath)).exists()) {
            this.setMessage(Messages.getFormattedString("error.invalidConnectionFilePath", new Object[]{cpFile.getPath()}), 3);
            return;
        }
        this.odaHome = dataSourceProps.getProperty("HOME");
        this.charSet = dataSourceProps.getProperty("CHARSET");
        this.flatfileDelimiterType = dataSourceProps.getProperty("DELIMTYPE");
        this.inclColumnNameLine = dataSourceProps.getProperty("INCLCOLUMNNAME");
        this.inclTypeLine = dataSourceProps.getProperty("INCLTYPELINE");
    }

    private void updateFileListAndCharSet() {
        if (this.fileViewer != null && !this.fileViewer.getControl().isDisposed()) {
            File[] files;
            if (this.odaHome == null) {
                this.disableAll();
                return;
            }
            File folder = new File(this.odaHome);
            if (folder.isDirectory() && folder.exists()) {
                files = folder.getAbsoluteFile().listFiles(new CSVFileFilter(this.fileFilter.getCombo().getText()));
                if (files != null) {
                    this.fileViewer.setInput((Object)files);
                } else {
                    this.fileViewer.setInput((Object)new File[0]);
                }
            } else {
                this.fileViewer.setInput((Object)new File[0]);
            }
            files = (File[])this.fileViewer.getInput();
            if (files.length > 0) {
                this.enableListAndViewer();
                File toSelectFile = null;
                if (this.selectedFile != null) {
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].equals(this.selectedFile)) {
                            toSelectFile = this.selectedFile;
                            break;
                        }
                        ++i;
                    }
                }
                if (toSelectFile == null) {
                    toSelectFile = files[0];
                }
                this.fileViewer.setSelection((ISelection)new StructuredSelection((Object)toSelectFile));
                if (this.nameOfFileWithErrorInLastAccess == null || !this.nameOfFileWithErrorInLastAccess.equals(this.fileViewer.getCombo().getText())) {
                    this.setMessage(DEFAULT_MESSAGE);
                }
            } else {
                this.setMessage(Messages.getFormattedString("error.noCSVFiles", new Object[]{folder.getAbsolutePath()}));
                this.disableAll();
            }
        }
    }

    private String[] getFileColumnNames(File file) {
        String[] result;
        List propList = this.getQueryColumnsInfo("select * from " + file.getName(), file);
        if (propList != null) {
            this.originalFileColumnsInfoList = new ArrayList(propList);
            result = new String[propList.size()];
            int i = 0;
            while (i < propList.size()) {
                result[i] = ((String[])propList.get(i))[1];
                ++i;
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    private List getQueryColumnsInfo(String queryText, File file) {
        FlatFileDriver ffDriver = new FlatFileDriver();
        IConnection conn = null;
        ArrayList<String[]> columnList = new ArrayList<String[]>();
        try {
            conn = ffDriver.getConnection(null);
            IResultSetMetaData metadata = this.getResultSetMetaData(queryText, file, conn);
            int columnCount = metadata.getColumnCount();
            if (columnCount == 0) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            int i = 0;
            while (i < columnCount) {
                String[] result;
                result = new String[]{metadata.getColumnName(i + 1), this.getOriginalColumnName(result[0], this.savedSelectedColumnsInfoString, metadata), this.getDataTypeDisplayName(new Integer(metadata.getColumnType(i + 1)))};
                columnList.add(result);
                ++i;
            }
            ArrayList<String[]> arrayList = columnList;
            return arrayList;
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.updateExceptionInfo();
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void updateExceptionInfo() {
        this.nameOfFileWithErrorInLastAccess = this.fileViewer.getCombo().getText();
        if (this.availableList.getItemCount() == 0) {
            this.disableAvailableListAndButtons();
        }
    }

    private void disableAvailableListAndButtons() {
        this.availableList.setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
    }

    private String getDataTypeDisplayName(Integer type) {
        if (this.dataTypeDisplayNameMap.get(type) != null) {
            return (String)this.dataTypeDisplayNameMap.get(type);
        }
        return Messages.getString("datatypes.string");
    }

    private String getDataTypeValue(String displayName) {
        if (this.dataTypeValueMape.get(displayName) != null) {
            return (String)this.dataTypeValueMape.get(displayName);
        }
        return "STRING";
    }

    private String getOriginalColumnName(String name, String columnsInfo, IResultSetMetaData metadata) {
        String originalName = null;
        if (columnsInfo.length() != 0) {
            ColumnsInfoUtil ciu = new ColumnsInfoUtil(columnsInfo);
            String[] names = ciu.getColumnNames();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    originalName = ciu.getOriginalColumnNames()[i];
                    break;
                }
                ++i;
            }
        }
        if (originalName == null) {
            try {
                int j = 0;
                while (j < metadata.getColumnCount()) {
                    if (name.equals(metadata.getColumnName(j + 1))) {
                        originalName = name;
                    }
                    ++j;
                }
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        return originalName;
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException odaException) {}
    }

    private IResultSetMetaData getResultSetMetaData(String queryText, File file, IConnection conn) throws OdaException {
        Properties prop = new Properties();
        if (file != null) {
            if (file.getParent() == null) {
                throw new OdaException(Messages.getString("error.unexpectedError"));
            }
            prop.put("HOME", file.getParent());
        }
        if (this.flatfileDelimiterType != null) {
            prop.put("DELIMTYPE", this.flatfileDelimiterType);
        }
        if (this.charSet != null) {
            prop.put("CHARSET", this.charSet);
        }
        if (this.inclColumnNameLine != null) {
            prop.put("INCLCOLUMNNAME", this.inclColumnNameLine);
        }
        if (this.inclTypeLine != null) {
            prop.put("INCLTYPELINE", this.inclTypeLine);
        }
        this.savedSelectedColumnsInfoString = new QueryTextUtil(queryText).getColumnsInfo();
        conn.open(prop);
        IQuery query = conn.newQuery(null);
        query.setMaxRows(1);
        query.prepare(queryText);
        query.executeQuery();
        return query.getMetaData();
    }

    private void enableListAndViewer() {
        this.availableList.setEnabled(true);
        this.selectedColumnsViewer.getTable().setEnabled(true);
    }

    private void disableAll() {
        this.availableList.setEnabled(false);
        this.selectedColumnsViewer.getTable().setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.setPageComplete(false);
    }

    private void setDisplayContent(List list, TableViewer tViewer) {
        tViewer.getTable().removeAll();
        tViewer.setInput((Object)list);
        tViewer.getTable().select(tViewer.getTable().getTopIndex());
    }

    private String getQuery() {
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            return "";
        }
        String tableName = null;
        StringBuffer buf = new StringBuffer();
        File file = (File)((StructuredSelection)this.fileViewer.getSelection()).getFirstElement();
        if (file != null) {
            tableName = file.getName();
        }
        if (tableName != null) {
            if (this.availableList.getItemCount() == 0) {
                buf.append("select * from ").append(tableName);
            } else {
                buf.append("select ");
                String[] columns = new String[this.selectedColumnsViewer.getTable().getItemCount()];
                int m = 0;
                while (m < columns.length) {
                    columns[m] = this.selectedColumnsViewer.getTable().getItem(m).getText(1);
                    ++m;
                }
                int n = 0;
                while (n < columns.length) {
                    StringBuffer sb = new StringBuffer();
                    char[] columnChars = columns[n].toCharArray();
                    int i = 0;
                    while (i < columnChars.length) {
                        if (columnChars[i] == '\"') {
                            sb.append("\\\"");
                        } else if (columnChars[i] == '\\') {
                            sb.append("\\\\");
                        } else {
                            sb.append(columnChars[i]);
                        }
                        ++i;
                    }
                    buf.append(String.valueOf('\"') + sb.toString() + '\"');
                    if (n < columns.length - 1) {
                        buf.append(", ");
                    }
                    ++n;
                }
                buf.append(" from ").append(tableName);
            }
        }
        return buf.toString();
    }

    private void updateValuesFromQuery(String queryText) {
        try {
            String query = new QueryTextUtil(queryText).getQuery();
            String[] splitQuery = FileSelectionWizardPage.stripFromClause(query);
            if (splitQuery.length == 2) {
                File f;
                String table = splitQuery[1];
                String columns = this.stripSelect(splitQuery[0]);
                if (table != null && columns != null && (f = this.selectTableFromQuery(table)) != null) {
                    this.updateColumnsFromQuery(queryText, f);
                }
            }
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.updateExceptionInfo();
        }
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private void updateColumnsFromQuery(String queryText, File file) {
        this.availableList.setItems(this.getFileColumnNames(file));
        this.selectedColumnsViewer.getTable().removeAll();
        this.savedSelectedColumnsInfoList.clear();
        this.savedSelectedColumnsInfoList = this.getQueryColumnsInfo(queryText, file);
        this.setDisplayContent(this.savedSelectedColumnsInfoList, this.selectedColumnsViewer);
        this.setPageComplete(true);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private String stripSelect(String selectedColumns) {
        String[] result = selectedColumns.split("SELECT ");
        if (result.length == 2) {
            return result[1];
        }
        return null;
    }

    private static String[] stripFromClause(String query) {
        query = query.toUpperCase();
        return query.split(" FROM ");
    }

    private File selectTableFromQuery(String tableName) {
        this.resetInitialized();
        this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)MATCH_ALL_FILES));
        File[] files = (File[])this.fileViewer.getInput();
        if (files != null) {
            int n = 0;
            while (n < files.length) {
                if (files[n].getName().equalsIgnoreCase(tableName)) {
                    this.resetInitialized();
                    if (tableName.toLowerCase().endsWith(CSV_EXTENSION)) {
                        this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_CSV_EXTENSION));
                    } else if (tableName.toLowerCase().endsWith(TXT_EXTENSION)) {
                        this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_TXT_EXTENSION));
                    } else if (tableName.toLowerCase().endsWith(SSV_EXTENSION)) {
                        this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_SSV_EXTENSION));
                    } else if (tableName.toLowerCase().endsWith(TSV_EXTENSION)) {
                        this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_TSV_EXTENSION));
                    } else if (tableName.toLowerCase().endsWith(PSV_EXTENSION)) {
                        this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_PSV_EXTENSION));
                    }
                    this.fileViewer.setSelection((ISelection)new StructuredSelection((Object)files[n]));
                    return files[n];
                }
                ++n;
            }
        }
        return null;
    }

    private void resetInitialized() {
        this.initialized = false;
    }

    private void populateFileFilter() {
        if (this.fileFilter != null && !this.fileFilter.getControl().isDisposed() && this.fileFilter.getCombo().getSelectionIndex() == -1) {
            if ("COMMA".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_CSV_EXTENSION);
                this.selectedFileFilter = ALL_CSV_EXTENSION;
            } else if ("SEMICOLON".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_SSV_EXTENSION);
                this.selectedFileFilter = ALL_SSV_EXTENSION;
            } else if ("TAB".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_TSV_EXTENSION);
                this.selectedFileFilter = ALL_TSV_EXTENSION;
            } else if ("PIPE".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_PSV_EXTENSION);
                this.selectedFileFilter = ALL_PSV_EXTENSION;
            } else {
                this.selectedFileFilter = MATCH_ALL_FILES;
            }
            this.fileFilter.add((Object)ALL_TXT_EXTENSION);
            this.fileFilter.add((Object)MATCH_ALL_FILES);
            this.fileFilter.getCombo().select(0);
        }
    }

    private void moveUpItem() {
        int count = this.selectedColumnsViewer.getTable().getItemCount();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        if (index > 0 && index < count) {
            if (!this.btnMoveDown.isEnabled()) {
                this.btnMoveDown.setEnabled(true);
            }
            Object obj = this.savedSelectedColumnsInfoList.get(index);
            this.savedSelectedColumnsInfoList.set(index, this.savedSelectedColumnsInfoList.get(index - 1));
            this.savedSelectedColumnsInfoList.set(index - 1, obj);
            this.selectedColumnsViewer.refresh();
            this.selectedColumnsViewer.getTable().setSelection(index - 1);
        }
        if (index == 1) {
            this.btnMoveUp.setEnabled(false);
        }
    }

    private void moveDownItem() {
        int count = this.selectedColumnsViewer.getTable().getItemCount();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        if (index > -1 && index < count - 1) {
            if (!this.btnMoveUp.isEnabled()) {
                this.btnMoveUp.setEnabled(true);
            }
            Object obj = this.savedSelectedColumnsInfoList.get(index);
            this.savedSelectedColumnsInfoList.set(index, this.savedSelectedColumnsInfoList.get(index + 1));
            this.savedSelectedColumnsInfoList.set(index + 1, obj);
            this.selectedColumnsViewer.refresh();
            this.selectedColumnsViewer.getTable().setSelection(index + 1);
        }
        if (index == count - 2) {
            this.btnMoveDown.setEnabled(false);
        }
    }

    private void addColumns() {
        List addedItems = this.createAddedColumnsInfo(this.availableList.getSelection());
        int i = 0;
        while (i < addedItems.size()) {
            this.savedSelectedColumnsInfoList.add(addedItems.get(i));
            ++i;
        }
        this.setDisplayContent(this.savedSelectedColumnsInfoList, this.selectedColumnsViewer);
        this.selectedColumnsViewer.getTable().setSelection(this.selectedColumnsViewer.getTable().getItemCount() - 1);
        int nextSelectionIndex = this.availableList.getSelectionIndex() + 1;
        if (nextSelectionIndex < this.availableList.getItemCount()) {
            this.availableList.setSelection(nextSelectionIndex);
            this.btnAdd.setEnabled(true);
        } else if (this.availableList.getSelectionCount() == 0) {
            this.btnAdd.setEnabled(false);
        }
        this.selectedColumnsViewer.getTable().setSelection(-1);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(true);
    }

    private List createAddedColumnsInfo(String[] addedColumnNames) {
        ArrayList<String[]> addedColumnsInfo = new ArrayList<String[]>();
        int count = 0;
        int i = 0;
        while (i < addedColumnNames.length) {
            count = this.getExistenceCount(addedColumnNames[i]);
            String[] addedColumns = new String[]{count == 0 ? addedColumnNames[i] : String.valueOf(addedColumnNames[i]) + "_" + count, addedColumnNames[i], this.getColumnTypeName(addedColumnNames[i])};
            addedColumnsInfo.add(addedColumns);
            ++i;
        }
        return addedColumnsInfo;
    }

    private String getColumnTypeName(String columnName) {
        int i = 0;
        while (i < this.originalFileColumnsInfoList.size()) {
            if (columnName.equals(((String[])this.originalFileColumnsInfoList.get(i))[1])) {
                return ((String[])this.originalFileColumnsInfoList.get(i))[2];
            }
            ++i;
        }
        return null;
    }

    private void removeColumns() {
        TableItem[] tis = this.selectedColumnsViewer.getTable().getSelection();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        String[] removedColumnInfo = null;
        ArrayList<String[]> removedItems = new ArrayList<String[]>();
        int i = 0;
        while (i < tis.length) {
            removedColumnInfo = new String[]{tis[i].getText(0), tis[i].getText(1), tis[i].getText(2)};
            removedItems.add(removedColumnInfo);
            ++i;
        }
        this.removeItemsFromSelectedOnes(removedItems);
        this.selectedColumnsViewer.refresh();
        if (index > 0) {
            this.selectedColumnsViewer.getTable().setSelection(index - 1);
        } else {
            this.selectedColumnsViewer.getTable().setSelection(index);
        }
        if (this.selectedColumnsViewer.getTable().getSelectionCount() == 0) {
            this.btnRemove.setEnabled(false);
        }
        if (this.savedSelectedColumnsInfoList.size() <= 1) {
            this.btnMoveDown.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
        }
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private void removeItemsFromSelectedOnes(List removedItemsList) {
        int i = 0;
        while (i < removedItemsList.size()) {
            int j = 0;
            while (j < this.savedSelectedColumnsInfoList.size()) {
                if (((String[])removedItemsList.get(i))[0].equals(((String[])this.savedSelectedColumnsInfoList.get(j))[0]) && ((String[])removedItemsList.get(i))[1].equals(((String[])this.savedSelectedColumnsInfoList.get(j))[1]) && ((String[])removedItemsList.get(i))[2].equals(((String[])this.savedSelectedColumnsInfoList.get(j))[2])) {
                    this.savedSelectedColumnsInfoList.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block6: {
            String queryText = this.getQueryText();
            if (queryText.equals(dataSetDesign.getQueryText())) {
                return;
            }
            dataSetDesign.setQueryText(queryText);
            IConnection conn = null;
            try {
                try {
                    FlatFileDriver ffDriver = new FlatFileDriver();
                    conn = ffDriver.getConnection(null);
                    IResultSetMetaData metadata = this.getResultSetMetaData(queryText, this.selectedFile, conn);
                    this.setResultSetMetaData(dataSetDesign, metadata);
                }
                catch (OdaException odaException) {
                    dataSetDesign.setResultSets(null);
                    this.closeConnection(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
    }

    private String getQueryText() {
        String query = this.getQuery();
        String queryText = query.length() > 0 ? String.valueOf(query) + " " + queryTextDelimiter + " " + columnsInfoStartSymbol + this.createSelectedColumnsInfoString() + columnsInfoEndSymbol : "";
        return queryText;
    }

    private String createSelectedColumnsInfoString() {
        String prop = "";
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            char[] columnNameChars = ((String[])this.savedSelectedColumnsInfoList.get(i))[0].toCharArray();
            StringBuffer columnNameBuf = new StringBuffer();
            char[] originalColumnNameChars = ((String[])this.savedSelectedColumnsInfoList.get(i))[1].toCharArray();
            StringBuffer originalColumnNameBuf = new StringBuffer();
            int m = 0;
            while (m < columnNameChars.length) {
                if (ColumnsInfoUtil.isColumnsInfoKeyWord((char)columnNameChars[m])) {
                    columnNameBuf.append("\\" + columnNameChars[m]);
                } else {
                    columnNameBuf.append(columnNameChars[m]);
                }
                ++m;
            }
            prop = String.valueOf(prop) + '\"' + columnNameBuf.toString() + '\"' + ",";
            m = 0;
            while (m < originalColumnNameChars.length) {
                if (ColumnsInfoUtil.isColumnsInfoKeyWord((char)originalColumnNameChars[m])) {
                    originalColumnNameBuf.append("\\" + originalColumnNameChars[m]);
                } else {
                    originalColumnNameBuf.append(originalColumnNameChars[m]);
                }
                ++m;
            }
            prop = String.valueOf(prop) + '\"' + originalColumnNameBuf.toString() + '\"' + ",";
            prop = i != this.savedSelectedColumnsInfoList.size() - 1 ? String.valueOf(prop) + this.getDataTypeValue(((String[])this.savedSelectedColumnsInfoList.get(i))[2]) + ";" : String.valueOf(prop) + this.getDataTypeValue(((String[])this.savedSelectedColumnsInfoList.get(i))[2]);
            ++i;
        }
        this.savedSelectedColumnsInfoString = prop;
        return this.savedSelectedColumnsInfoString;
    }

    private void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    class CSVFileFilter
    implements FilenameFilter {
        private String extension = null;

        CSVFileFilter(String ext) {
            this.extension = FileSelectionWizardPage.ALL_CSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.CSV_EXTENSION : (FileSelectionWizardPage.ALL_TXT_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.TXT_EXTENSION : (FileSelectionWizardPage.ALL_SSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.SSV_EXTENSION : (FileSelectionWizardPage.ALL_TSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.TSV_EXTENSION : (FileSelectionWizardPage.ALL_PSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.PSV_EXTENSION : null))));
        }

        public boolean accept(File dir, String name) {
            if (this.extension == null) {
                File file = new File(dir + File.separator + name);
                return file.isFile() && !file.isHidden();
            }
            return name.toLowerCase().endsWith(this.extension);
        }
    }
}

