/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionEditorPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfilePageWrapper;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfileUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.pages.impl.DefaultDataSourcePropertyPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.swt.widgets.Composite;

public class DbProfilePropertyPage
extends DataSourceEditorPage {
    private DbProfilePageWrapper m_pageHelper = null;
    private ProfileSelectionEditorPage.IUpdateDesignTask m_profileUpdateDesignTask;

    public DbProfilePropertyPage() {
        this.setMessage(DbProfilePageWrapper.DEFAULT_MESSAGE);
    }

    protected void createAndInitCustomControl(Composite parent, Properties profileProps) {
        if (this.m_pageHelper == null) {
            this.m_pageHelper = this.createDbProfilePageWrapper();
        }
        if (this.m_pageHelper != null) {
            try {
                this.m_pageHelper.createCustomControl(parent, !this.isSessionEditable());
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            this.m_pageHelper.initCustomControl(profileProps);
        } else {
            DataSourceEditorPage odaDefaultPage = this.createDefaultPropertyPage(profileProps);
            odaDefaultPage.createControl(parent);
            this.m_pageHelper = new DbProfilePageWrapper(this, (ProfilePropertyPage)odaDefaultPage);
        }
        this.setPingButtonVisible(false);
    }

    protected DbProfilePageWrapper createDbProfilePageWrapper() {
        IConnectionProfile pageProfile = this.getConnectionProfile();
        OdaConnectionProfile odaDbProfile = pageProfile instanceof OdaConnectionProfile ? (OdaConnectionProfile)pageProfile : new OdaConnectionProfile(pageProfile);
        ProfilePropertyPage customDbPropPage = DbProfileUtil.createDbPropertyPage(odaDbProfile, this.getOdaDataSourceId());
        if (customDbPropPage == null) {
            return null;
        }
        return new DbProfilePageWrapper(this, customDbPropPage);
    }

    private DataSourceEditorPage createDefaultPropertyPage(Properties dbProfileProps) {
        String errorMessage = null;
        errorMessage = !this.isInOdaDesignSession() ? Messages.dbProfilePage_notInDesignSession : Messages.dbProfilePage_noCustomPage;
        DefaultDataSourcePropertyPage odaDefaultPage = new DefaultDataSourcePropertyPage();
        try {
            odaDefaultPage.initEditSession(this.getDesignSession());
        }
        catch (OdaException ex) {
            errorMessage = String.valueOf(errorMessage) + "\n";
            errorMessage = String.valueOf(errorMessage) + ex.toString();
        }
        this.setMessage(errorMessage);
        return odaDefaultPage;
    }

    protected DbProfilePageWrapper getPageHelper() {
        return this.m_pageHelper;
    }

    protected void refresh(Properties customConnectionProps) {
    }

    public Properties collectCustomProperties(Properties profileProps) {
        if (this.m_pageHelper == null) {
            return profileProps;
        }
        Properties dbProfileProps = this.m_pageHelper.collectCustomProperties(profileProps);
        DbProfileUtil.setDbProviderIdInProperties(dbProfileProps, this.getDbProfileProviderId());
        return dbProfileProps;
    }

    String getDbProfileProviderId() {
        if (this.m_pageHelper == null) {
            return null;
        }
        return this.m_pageHelper.getDbProfileProviderId();
    }

    protected void setDataSourceDesignProperties(DataSourceDesign design, Properties propertyValuePairs) throws OdaException {
        DbProfileUtil.updateDataSourceDesignManifestProperties(design, propertyValuePairs);
    }

    public void initProfileSelectionEditSession(ProfileSelectionEditorPage profileSelectionPage) {
        if (profileSelectionPage == null) {
            return;
        }
        profileSelectionPage.delegatesTask(this.getProfileSelectionUpdateDesignTask());
    }

    private ProfileSelectionEditorPage.IUpdateDesignTask getProfileSelectionUpdateDesignTask() {
        if (this.m_profileUpdateDesignTask == null) {
            this.m_profileUpdateDesignTask = new ProfileSelectionEditorPage.IUpdateDesignTask(){

                public DataSourceDesign collectDataSourceDesign(DataSourceDesign design, ProfileSelectionEditorPage delegator, IConnectionProfile selectedConnProfile) throws OdaException {
                    if (selectedConnProfile == null) {
                        return design;
                    }
                    Properties customProps = this.collectCustomProperties(selectedConnProfile);
                    DbProfilePropertyPage.this.setDataSourceDesignProperties(design, customProps);
                    return design;
                }

                private Properties collectCustomProperties(IConnectionProfile selectedConnProfile) {
                    Properties customProps = selectedConnProfile.getBaseProperties();
                    String dbProfileProviderId = this.getDbProfileProviderId(selectedConnProfile);
                    DbProfileUtil.setDbProviderIdInProperties(customProps, dbProfileProviderId);
                    return customProps;
                }

                private String getDbProfileProviderId(IConnectionProfile connProfile) {
                    if (connProfile instanceof OdaConnectionProfile) {
                        return ((OdaConnectionProfile)connProfile).getDirectProviderId();
                    }
                    return null;
                }
            };
        }
        return this.m_profileUpdateDesignTask;
    }
}

