/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ExportProfilesDialog;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionPageHelper;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.filter.NewProfileAction;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProfileStoreCreationDialog
extends ExportProfilesDialog {
    private CheckboxTableViewer m_profilesViewer;
    private IConnectionProfile m_preSelectProfile;

    public ProfileStoreCreationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(super.getShellStyle() | 0x8000);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.profileStoreCreationDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.createParentDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.makeColumnsEqualWidth = false;
        groupGridLayout.numColumns = 3;
        Group group = this.createProfileSelectionGroup(container, (Layout)groupGridLayout);
        group.setText(Messages.profileStoreCreationDialog_grouptext);
        this.m_profilesViewer = this.setupCheckboxTableViewer((Composite)group);
        this.setCheckedProfile();
        GridData selectAllButtonData = new GridData();
        selectAllButtonData.horizontalAlignment = 16384;
        Button button = this.createSelectAllButton((Composite)group, selectAllButtonData);
        selectAllButtonData.widthHint = ProfileSelectionPageHelper.computeButtonWidth(button);
        GridData deselectAllButtonData = new GridData();
        deselectAllButtonData.horizontalAlignment = 16384;
        button = this.createDeselectAllButton((Composite)group, deselectAllButtonData);
        deselectAllButtonData.widthHint = ProfileSelectionPageHelper.computeButtonWidth(button);
        Button newButton = new Button((Composite)group, 8);
        newButton.setText(Messages.profilePage_button_new);
        newButton.setToolTipText(Messages.profileStoreCreationDialog_newbutton_tooltiptext);
        GridData newButtonData = new GridData();
        newButtonData.horizontalAlignment = 131072;
        newButtonData.verticalAlignment = 128;
        newButtonData.widthHint = ProfileSelectionPageHelper.computeButtonWidth(newButton);
        newButton.setLayoutData((Object)newButtonData);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleNewProfile();
            }

            private void handleNewProfile() {
                NewProfileAction newProfileAction = new NewProfileAction(ProfileStoreCreationDialog.this.getShell());
                newProfileAction.run();
                ProfileStoreCreationDialog.this.m_profilesViewer.refresh();
            }
        });
        Label spacingLabel = this.createVerticalSpacingLabel(container);
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 410;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new FormLayout());
        Label fileNameLabel = this.createFilePathLabel(composite, null);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)fileNameLabel, 6);
        data.width = 290;
        Text filenameText = this.setupFilePathText(composite, data);
        data = new FormData();
        data.left = new FormAttachment((Control)filenameText, 12);
        data.top = new FormAttachment((Control)spacingLabel, -1);
        Button browseButton = this.createFilePathBrowseButton(composite, data);
        data.width = ProfileSelectionPageHelper.computeButtonWidth(browseButton);
        this.setupEncryptContentCheckbox(container);
        this.setupHelp((Control)this.getShell());
        return container;
    }

    public void setPreSelectedProfile(IConnectionProfile profile) {
        this.m_preSelectProfile = profile;
    }

    private void setCheckedProfile() {
        if (this.m_profilesViewer == null || this.m_preSelectProfile == null) {
            return;
        }
        this.m_profilesViewer.setChecked((Object)this.m_preSelectProfile, true);
    }
}

