/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.Locale;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DataSetWizardBase;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class DataSetWizardPageCore
extends WizardPage {
    private String m_path;
    private String m_icon;
    private boolean m_hasInitialFocus = false;
    private ImageDescriptor m_iconDescriptor;
    private IPreferencePageContainer m_editorContainer;

    protected abstract DataSetDesign collectDataSetDesign(DataSetDesign var1);

    protected abstract void refresh(DataSetDesign var1);

    protected abstract boolean canLeave();

    protected abstract void cleanup();

    protected DataSetWizardPageCore(String pageName) {
        super(pageName);
    }

    protected DataSetWizardPageCore(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (this.getEditorContainer() != null) {
            this.getEditorContainer().updateMessage();
        }
    }

    protected IPreferencePageContainer getEditorContainer() {
        return this.m_editorContainer;
    }

    void setEditorContainer(IPreferencePageContainer container) {
        this.m_editorContainer = container;
    }

    String getPagePath() {
        return this.m_path;
    }

    protected void setPagePath(String path) {
        this.m_path = path;
    }

    public String getIconFilePath() {
        return this.m_icon;
    }

    protected void setIconFilePath(String iconFilePath) {
        this.m_icon = iconFilePath;
    }

    public ImageDescriptor getIconDescriptor() {
        if (this.m_iconDescriptor != null) {
            return this.m_iconDescriptor;
        }
        String iconPath = this.getIconFilePath();
        if (iconPath == null || iconPath.length() == 0) {
            return null;
        }
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return null;
        }
        try {
            this.m_iconDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)wizard.getOdaDesignerPluginId(), (String)iconPath);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return this.m_iconDescriptor;
    }

    boolean hasInitialFocus() {
        return this.m_hasInitialFocus;
    }

    protected void setHasInitialFocus() {
        this.m_hasInitialFocus = true;
    }

    protected DataSetDesign getInitializationDesign() {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.copyRequestDataSetDesign();
    }

    protected DataSetDesign getEditingDesign() {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.getEditingDataSet();
    }

    protected DesignerState getInitializationDesignerState() {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.copyRequestDesignerState();
    }

    protected DesignerState getEditingDesignerState() {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.getResponseDesignerState();
    }

    protected Locale getInitializationLocale() {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.copySessionLocale();
    }

    protected boolean isSessionEditable() {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return true;
        }
        return wizard.isSessionEditable();
    }

    protected DataSetWizardBase getOdaWizard() {
        if (this.getWizard() instanceof DataSetWizardBase) {
            return (DataSetWizardBase)this.getWizard();
        }
        return null;
    }

    protected DataSetDesign finishDataSetDesign(DataSetDesign design) {
        this.collectResponseState();
        return this.collectDataSetDesign(design);
    }

    protected void collectResponseState() {
        this.setResponseSessionStatus(null);
        this.setResponseDesignerState(null);
    }

    protected void setResponseSessionStatus(SessionStatus status) {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard != null) {
            wizard.setResponseSessionStatus(status);
        }
    }

    protected void setResponseDesignerState(DesignerState customDesignerState) {
        DataSetWizardBase wizard = this.getOdaWizard();
        if (wizard != null) {
            wizard.setResponseDesignerState(customDesignerState);
        }
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }
}

