/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.designsession;

import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIExtensionManifest;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class DesignSessionUtilBase {
    protected DesignSessionUtilBase() {
    }

    protected static Property[] getDataSourcePublicPropertiesDefn(String odaDataSourceId) throws OdaException {
        try {
            ExtensionManifest runtimeManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
            return runtimeManifest.getProperties();
        }
        catch (IllegalArgumentException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    protected static Property[] getDataSetPublicPropertiesDefn(String odaDataSourceId, String odaDataSetId) throws OdaException {
        try {
            ExtensionManifest runtimeManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
            DataSetType dataSetType = runtimeManifest.getDataSetType(odaDataSetId);
            return dataSetType.getProperties();
        }
        catch (IllegalArgumentException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    static DataSetUIElement getDataSetUIElement(String odaDataSourceId, String odaDataSetId) throws OdaException {
        UIExtensionManifest manifest = UIManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
        DataSetUIElement dataSetElement = null;
        if (manifest != null) {
            dataSetElement = manifest.getDataSetUIElement(odaDataSetId);
        }
        if (dataSetElement == null) {
            throw new OdaException(Messages.bind((String)Messages.designSession_missingDataSetUIElement, (Object)odaDataSourceId, (Object)odaDataSetId));
        }
        return dataSetElement;
    }

    protected static String validateRequestSessionImpl(DesignSessionRequest requestSession) throws OdaException {
        String odaDataSourceId = null;
        try {
            odaDataSourceId = DesignUtil.validateRequestSession((DesignSessionRequest)requestSession);
        }
        catch (IllegalStateException ex) {
            throw new OdaException((Throwable)ex);
        }
        return odaDataSourceId;
    }

    protected static void validateDataSourceDesignImpl(DataSourceDesign dataSourceDesign) throws OdaException {
        try {
            DesignUtil.validateDataSourceDesign((DataSourceDesign)dataSourceDesign);
        }
        catch (IllegalStateException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    protected static OdaDesignSession createNewDataSetRequestSession(String newDataSetName, String odaDataSetId, DataSourceDesign dataSourceDesign) throws OdaException {
        if (newDataSetName == null || newDataSetName.length() == 0 || dataSourceDesign == null) {
            throw new OdaException(Messages.designSession_invalidArgument);
        }
        OdaDesignSession newSession = DesignFactory.eINSTANCE.createRequestDesignSession(dataSourceDesign);
        DataSetDesign newDataSetDesign = newSession.getRequestDataSetDesign();
        newDataSetDesign.setName(newDataSetName);
        newDataSetDesign.setOdaExtensionDataSetId(odaDataSetId);
        DesignSessionUtilBase.validateRequestSessionImpl(newSession.getRequest());
        return newSession;
    }

    protected static void toElementOptionalAttributes(DataElementAttributes paramAttrs, IParameterMetaData pmd, int i) {
        try {
            paramAttrs.setPrecision(pmd.getPrecision(i));
            paramAttrs.setScale(pmd.getScale(i));
            paramAttrs.setNullability(DesignSessionUtilBase.toElementNullability(pmd.isNullable(i)));
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (OdaException odaEx) {
            odaEx.printStackTrace();
        }
    }

    protected static ElementNullability toElementNullability(int odaNullability) {
        ElementNullability toValue;
        switch (odaNullability) {
            case 0: {
                toValue = ElementNullability.NOT_NULLABLE_LITERAL;
                break;
            }
            case 2: {
                toValue = ElementNullability.UNKNOWN_LITERAL;
                break;
            }
            default: {
                toValue = ElementNullability.NULLABLE_LITERAL;
            }
        }
        return toValue;
    }
}

