/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.ConnectionPropertyHandler;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaQuery;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaConnection
extends OdaObject
implements IConnection {
    private int m_errorNumber;
    private String m_errorMessage;
    private static Hashtable sm_clsLdrOpenedConnCountMap;
    private static int sm_maxOpenConnections;
    private int m_numOfOpenedStatements;
    private Hashtable m_dsMetaDataCollection;
    private OdaDataSetMetaData m_defaultDSMetaData;
    private Locale m_locale;
    private Object m_driverAppContext;
    private Object m_connAppContext;
    private ConnectionPropertyHandler m_propertyHandler;

    static {
        sm_maxOpenConnections = 0;
    }

    protected OdaConnection(IConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader, ClassLoader originalClassLoader) {
        super(connection, switchContextClassloader, driverClassLoader, originalClassLoader);
        String context = "OdaConnection.OdaConnection( " + connection + ")\t";
        this.logMethodCalled(context);
        this.clearDriverError();
        this.m_numOfOpenedStatements = 0;
        this.logMethodExitWithReturn(context, this);
    }

    static void setMaxConnections(int maxOpenConnections) {
        sm_maxOpenConnections = maxOpenConnections;
    }

    private Hashtable getDSMetaDataCollection() {
        if (this.m_dsMetaDataCollection == null) {
            this.m_dsMetaDataCollection = new Hashtable();
        }
        return this.m_dsMetaDataCollection;
    }

    private IConnection getConnection() {
        return (IConnection)this.getObject();
    }

    protected void handleError(OdaException exception) throws OdaException {
        super.handleError(exception);
        int errorNumber = exception.getErrorCode();
        String errorMessage = exception.toString();
        this.setDriverError(errorNumber, errorMessage);
        throw exception;
    }

    void setDriverError(int errorNumber, String errorMessage) {
        this.m_errorNumber = errorNumber;
        this.m_errorMessage = errorMessage;
    }

    public int getDriverErrorNumber() {
        return this.m_errorNumber;
    }

    public String getDriverErrorMessage() {
        return this.m_errorMessage;
    }

    public void clearDriverError() {
        this.m_errorNumber = 0;
        this.m_errorMessage = "";
    }

    boolean canSupportMoreOpenedStatements() throws OdaException {
        int maxStatements = this.getMaxQueries();
        return maxStatements == 0 || this.m_numOfOpenedStatements < maxStatements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxQueries() throws OdaException {
        int n;
        this.logMethodCalled("OdaConnection.getMaxQueries()\t");
        try {
            try {
                this.setContextClassloader();
                int ret = this.getConnection().getMaxQueries();
                this.logMethodExitWithReturn("OdaConnection.getMaxQueries()\t", ret);
                n = ret;
                Object var2_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                int n2 = this.handleUnsupportedOpAndRetZero(uoException, "IConnection.getMaxQueries()");
                Object var2_10 = null;
                this.resetContextClassloader();
                return n2;
            }
            catch (RuntimeException rtException) {
                int n3 = this.handleErrorAndReturnNegOne(rtException);
                Object var2_11 = null;
                this.resetContextClassloader();
                return n3;
            }
            catch (OdaException odaException) {
                int n4 = this.handleErrorAndReturnNegOne(odaException);
                Object var2_12 = null;
                this.resetContextClassloader();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var2_13 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return n;
    }

    void addOpenStatement(OdaQuery statement) {
        if (statement.isPreparedSuccessfully()) {
            ++this.m_numOfOpenedStatements;
        }
    }

    void removeOpenStatement(OdaQuery statement) {
        if (statement.isPreparedSuccessfully()) {
            --this.m_numOfOpenedStatements;
        }
    }

    Locale getLocale() {
        return this.m_locale;
    }

    void setDriverAppContext(Object context) {
        this.m_driverAppContext = context;
    }

    private Object getDriverAppContext() {
        return this.m_driverAppContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(Properties connProperties) throws OdaException {
        String context;
        block10: {
            block9: {
                context = "OdaConnection.open( " + connProperties + " )\t";
                this.logMethodCalled(context);
                this.setAppContext(this.getDriverAppContext());
                try {
                    try {
                        this.setContextClassloader();
                        if (this.checkIsOpen()) {
                            this.log(context, "The ODA connection is already open; skip call to the IConnection.open method.");
                            this.logMethodExit(context);
                            Object var4_3 = null;
                            break block9;
                        }
                        if (sm_maxOpenConnections != 0 && this.getOpenedConnCount() >= sm_maxOpenConnections) {
                            throw this.newOdaException(Messages.helper_maxConcurrentConnectionsReached);
                        }
                        Properties effectiveConnProps = this.getEffectiveProperties(connProperties);
                        this.getConnection().open(effectiveConnProps);
                    }
                    catch (UnsupportedOperationException uoException) {
                        this.handleUnsupportedOp(uoException, "IConnection.open( Properties connProperties )");
                    }
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.resetContextClassloader();
                    throw throwable;
                }
            }
            this.resetContextClassloader();
            return;
        }
        Object var4_5 = null;
        this.resetContextClassloader();
        this.incrOpenedConnCount();
        this.logMethodExit(context);
    }

    Object getAppContext() {
        return this.m_connAppContext;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAppContext(Object context) throws OdaException {
        String contextObjInfo = context == null ? "null" : context.toString();
        this.logMethodCalled("OdaConnection.setAppContext()\t");
        if (this.m_connAppContext == context) {
            this.log("OdaConnection.setAppContext()\t", "Same pass-thru application context object: " + contextObjInfo);
            this.logMethodExit("OdaConnection.setAppContext()\t");
            return;
        }
        this.processConsumerAppContext(context);
        try {
            try {
                this.setContextClassloader();
                this.log("OdaConnection.setAppContext()\t", "Passing thru application context to underlying ODA connection: " + contextObjInfo);
                this.getConnection().setAppContext(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.logUnsupportedOp(uoException, "IConnection.setAppContext");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.resetContextClassloader();
        this.m_connAppContext = context;
        this.logMethodExit("OdaConnection.setAppContext()\t");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws OdaException {
        block9: {
            block8: {
                this.logMethodCalled("OdaConnection.close()\t");
                try {
                    try {
                        this.setContextClassloader();
                        if (!this.checkIsOpen()) {
                            this.log("OdaConnection.close()\t", "The ODA connection is not open; skip call to the IConnection.close method.");
                            this.logMethodExit("OdaConnection.close()\t");
                            Object var2_1 = null;
                            break block8;
                        }
                        this.getConnection().close();
                        this.clearDriverError();
                        this.m_numOfOpenedStatements = 0;
                        this.decrOpenedConnCount();
                        this.logMethodExit("OdaConnection.close()\t");
                    }
                    catch (UnsupportedOperationException uoException) {
                        this.handleUnsupportedOp(uoException, "IConnection.close()");
                    }
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.resetContextClassloader();
                    throw throwable;
                }
            }
            this.resetContextClassloader();
            return;
        }
        Object var2_3 = null;
        this.resetContextClassloader();
    }

    private int getOpenedConnCount() {
        Hashtable counts = this.getClsLdrOpenedConnMap();
        Object value = counts.get(this.getConnection().getClass().getClassLoader());
        int i = value == null ? 0 : (Integer)value;
        return i;
    }

    private void incrOpenedConnCount() {
        this.incrOrDecrOpenedConnectionCountMap(true);
    }

    private void decrOpenedConnCount() {
        this.incrOrDecrOpenedConnectionCountMap(false);
    }

    private void incrOrDecrOpenedConnectionCountMap(boolean increment) {
        int i;
        ClassLoader driverClassLoader;
        Hashtable counts = this.getClsLdrOpenedConnMap();
        Object value = counts.get(driverClassLoader = this.getConnection().getClass().getClassLoader());
        int n = i = value == null ? 0 : (Integer)value;
        if (increment) {
            ++i;
        } else if (i > 0) {
            --i;
        }
        Integer newValue = new Integer(i);
        counts.put(driverClassLoader, newValue);
    }

    private Hashtable getClsLdrOpenedConnMap() {
        if (sm_clsLdrOpenedConnCountMap == null) {
            sm_clsLdrOpenedConnCountMap = new Hashtable();
        }
        return sm_clsLdrOpenedConnCountMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOpen() throws OdaException {
        boolean bl;
        this.logMethodCalled("OdaConnection.isOpen()\t");
        try {
            try {
                this.setContextClassloader();
                boolean ret = this.checkIsOpen();
                this.logMethodExitWithReturn("OdaConnection.isOpen()\t", ret);
                bl = ret;
                Object var2_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                boolean bl2 = this.handleUnsupportedOpAndRetFalse(uoException, "IConnection.isOpen()");
                Object var2_10 = null;
                this.resetContextClassloader();
                return bl2;
            }
            catch (RuntimeException rtException) {
                boolean bl3 = this.handleErrorAndReturnFalse(rtException);
                Object var2_11 = null;
                this.resetContextClassloader();
                return bl3;
            }
            catch (OdaException odaException) {
                boolean bl4 = this.handleErrorAndReturnFalse(odaException);
                Object var2_12 = null;
                this.resetContextClassloader();
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var2_13 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return bl;
    }

    private boolean checkIsOpen() throws OdaException {
        return this.getConnection().isOpen();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        String context = "OdaConnection.getMetaData( " + dataSetType + " )\t";
        this.logMethodCalled(context);
        try {
            OdaDataSetMetaData odaDataSetMetaData;
            try {
                this.setContextClassloader();
                OdaDataSetMetaData odaDSMetaData = this.doGetMetaData(dataSetType);
                if (odaDSMetaData == null) {
                    throw new UnsupportedOperationException();
                }
                this.logMethodExitWithReturn(context, odaDSMetaData);
                odaDataSetMetaData = odaDSMetaData;
                Object var4_8 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block7: {
                    this.handleUnsupportedOp(uoException, "IConnection.getMetaData( String dataSetType )");
                    break block7;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block7;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var4_9 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaDataSetMetaData;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    OdaDataSetMetaData doGetMetaData(String dataSetType) throws OdaException {
        IDataSetMetaData metadata;
        if (dataSetType == null) {
            if (this.m_defaultDSMetaData != null) {
                return this.m_defaultDSMetaData;
            }
        } else if (this.getDSMetaDataCollection().containsKey(dataSetType)) {
            OdaDataSetMetaData ret = (OdaDataSetMetaData)this.getDSMetaDataCollection().get(dataSetType);
            return ret;
        }
        if ((metadata = this.getConnection().getMetaData(dataSetType)) == null) {
            return null;
        }
        OdaDataSetMetaData odaDSMetaData = new OdaDataSetMetaData(metadata, this, this.switchContextClassloader(), this.getDriverClassLoader());
        if (dataSetType == null) {
            this.m_defaultDSMetaData = odaDSMetaData;
        } else {
            this.getDSMetaDataCollection().put(dataSetType, odaDSMetaData);
        }
        return odaDSMetaData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IQuery newQuery(String dataSetType) throws OdaException {
        String context = "OdaConnection.newQuery( " + dataSetType + " )\t";
        this.logMethodCalled(context);
        try {
            OdaQuery odaQuery;
            try {
                this.setContextClassloader();
                if (!this.canSupportMoreOpenedStatements()) {
                    this.logMethodExitWithReturn(context, false);
                    throw this.newOdaException(Messages.helper_maxConcurrentStatementsReached);
                }
                IQuery statement = this.getConnection().newQuery(dataSetType);
                if (statement == null) {
                    this.logMethodExit(context);
                    throw new UnsupportedOperationException();
                }
                OdaQuery ret = statement instanceof IAdvancedQuery ? this.newAdvancedQueryHelper((IAdvancedQuery)statement, dataSetType) : this.newQueryHelper(statement, dataSetType);
                this.logMethodExitWithReturn(context, ret);
                odaQuery = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IConnection.newQuery( String dataSetType )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaQuery;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    protected OdaQuery newQueryHelper(IQuery statement, String dataSetType) {
        return new OdaQuery(statement, this, dataSetType, this.switchContextClassloader(), this.getDriverClassLoader());
    }

    protected OdaAdvancedQuery newAdvancedQueryHelper(IAdvancedQuery advancedQuery, String dataSetType) {
        return new OdaAdvancedQuery(advancedQuery, this, dataSetType, this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws OdaException {
        this.logMethodCalled("OdaConnection.commit()\t");
        try {
            try {
                this.setContextClassloader();
                this.getConnection().commit();
                this.logMethodExit("OdaConnection.commit()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IConnection.commit()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var2_6 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws OdaException {
        this.logMethodCalled("OdaConnection.rollback()\t");
        try {
            try {
                this.setContextClassloader();
                this.getConnection().rollback();
                this.logMethodExit("OdaConnection.rollback()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IConnection.rollback()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var2_6 = null;
        }
        this.resetContextClassloader();
    }

    public void setLocale(String localeString) throws Throwable {
        String context = "OdaConnection.setLocale( " + localeString + " )\t";
        this.logMethodCalled(context);
        if (localeString == null || localeString.length() != 5) {
            this.m_locale = Locale.getDefault();
        } else {
            String language = localeString.substring(0, 2);
            String country = localeString.substring(3, 5);
            this.m_locale = new Locale(language, country);
        }
        try {
            Class[] parameterTypes = new Class[]{this.m_locale.getClass()};
            Object[] arguments = new Object[]{this.m_locale};
            this.findAndInvokeMethod("setLocale", parameterTypes, arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            if (cause instanceof RuntimeException) {
                this.handleError((RuntimeException)cause);
                return;
            }
            if (cause instanceof OdaException) {
                this.handleError((OdaException)cause);
                return;
            }
            throw cause;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        this.logMethodExit(context);
    }

    private void processConsumerAppContext(Object context) {
        this.m_propertyHandler = new ConnectionPropertyHandler(context);
    }

    protected ConnectionPropertyHandler getPropertyHandler() {
        if (this.m_propertyHandler == null) {
            this.m_propertyHandler = new ConnectionPropertyHandler(null);
        }
        return this.m_propertyHandler;
    }

    private Properties getEffectiveProperties(Properties candidateProperties) throws OdaException {
        return this.getPropertyHandler().getEffectiveProperties(candidateProperties);
    }
}

