/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.BlobReader;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;

public class OdaBlob
extends OdaDriverObject
implements IBlob {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String COMMA_SEPARATOR = ", ";

    protected OdaBlob(IBlob blob, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)blob, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaBlob( Blob , " + connection + " )\t";
        this.logMethodCalled(context);
    }

    private IBlob getDriverBlob() {
        return (IBlob)this.getObject();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws OdaException {
        this.logMethodCalled("OdaBlob.getBinaryStream()\t");
        try {
            InputStream inputStream;
            try {
                this.setContextClassloader();
                InputStream ret = this.getDriverBlob().getBinaryStream();
                this.logMethodExitWithReturn("OdaBlob.getBinaryStream()\t", ret);
                inputStream = ret;
                Object var2_6 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IBlob.getBinaryStream()");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var2_7 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return inputStream;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long position, int length) throws OdaException {
        String context = "OdaBlob.getBytes( " + position + COMMA_SEPARATOR + length + " )\t";
        this.logMethodCalled(context);
        byte[] ret = null;
        try {
            byte[] byArray;
            try {
                this.setContextClassloader();
                ret = this.getDriverBlob().getBytes(position, length);
                this.logMethodExitWithReturn(context, ret);
                byArray = ret;
                Object var7_7 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block7: {
                    ret = this.getBytesFromStream(position, length);
                    if (ret != null) {
                        this.logMethodExitWithReturn(context, ret);
                        byte[] byArray2 = ret;
                        Object var7_9 = null;
                        this.resetContextClassloader();
                        return byArray2;
                    }
                    this.handleUnsupportedOp(uoException, "IBlob.getBytes()");
                    break block7;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block7;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var7_8 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length() throws OdaException {
        long l;
        this.logMethodCalled("OdaBlob.length()\t");
        try {
            try {
                this.setContextClassloader();
                long ret = this.getDriverBlob().length();
                this.logMethodExitWithReturn("OdaBlob.length()\t", ret);
                l = ret;
                Object var3_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                long l2 = this.handleUnsupportedOpAndRetZero(uoException, "IBlob.length()");
                Object var3_10 = null;
                this.resetContextClassloader();
                return l2;
            }
            catch (RuntimeException rtException) {
                long l3 = this.handleErrorAndReturnZero(rtException);
                Object var3_11 = null;
                this.resetContextClassloader();
                return l3;
            }
            catch (OdaException odaException) {
                long l4 = this.handleErrorAndReturnZero(odaException);
                Object var3_12 = null;
                this.resetContextClassloader();
                return l4;
            }
        }
        catch (Throwable throwable) {
            Object var3_13 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytesFromStream(long startPos, int length) {
        String context = "OdaBlob.getBytesFromStream( " + startPos + COMMA_SEPARATOR + length + " )\t";
        byte[] ret = null;
        try {
            try {
                this.setContextClassloader();
                BlobReader reader = new BlobReader(this, this.getReaderBufferSize());
                ret = reader.getBytes(startPos, length);
            }
            catch (RuntimeException rte) {
                this.handleError(rte);
            }
            catch (IOException e) {
                this.log(context, e.toString());
            }
            catch (OdaException ex) {
                this.log(context, ex.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        this.resetContextClassloader();
        return ret;
    }

    protected int getReaderBufferSize() {
        return 2048;
    }
}

