/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.util.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;

public class PropertyProviderManifest {
    static final String DTP_ODA_PROPERTY_PROVIDER_EXT_POINT = "org.eclipse.datatools.connectivity.oda.consumer.propertyProvider";
    static final String PROP_SERVICE_ELEMENT = "dataSourcePropertyService";
    static final String APPLICATION_ID_ATTRIBUTE = "consumerApplicationId";
    static final String PROVIDER_CLASS_ATTRIBUTE = "providerClass";
    private IExtension m_providerExtension;
    private IConfigurationElement m_propServiceElement;
    private String m_namespace;
    private String m_applicationId;
    private String m_providerClassName;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.consumer.util.manifest.PropertyProviderManifest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    PropertyProviderManifest(IExtension providerExtension) throws OdaException {
        this.init(providerExtension);
    }

    protected PropertyProviderManifest() {
    }

    protected void init(IExtension providerExtension) throws OdaException {
        if (!$assertionsDisabled && providerExtension == null) {
            throw new AssertionError();
        }
        this.m_providerExtension = providerExtension;
        this.m_namespace = this.m_providerExtension.getContributor().getName();
        this.m_propServiceElement = ExtensionExplorer.getNamedElement(this.m_providerExtension, PROP_SERVICE_ELEMENT, APPLICATION_ID_ATTRIBUTE);
        if (this.m_propServiceElement == null) {
            throw new OdaException((Throwable)new IllegalArgumentException(this.m_namespace));
        }
        this.m_applicationId = this.m_propServiceElement.getAttribute(APPLICATION_ID_ATTRIBUTE);
        if (this.m_applicationId == null || this.m_applicationId.trim().length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(APPLICATION_ID_ATTRIBUTE));
        }
        this.m_providerClassName = this.m_propServiceElement.getAttribute(PROVIDER_CLASS_ATTRIBUTE);
        if (this.m_providerClassName == null || this.m_providerClassName.trim().length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(PROVIDER_CLASS_ATTRIBUTE));
        }
    }

    protected IExtension getProviderExtension() {
        return this.m_providerExtension;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    protected IConfigurationElement getPropertyServiceElement() {
        return this.m_propServiceElement;
    }

    public String getApplicationId() {
        return this.m_applicationId;
    }

    public String getProviderClassName() {
        return this.m_providerClassName;
    }

    public IPropertyProvider createProvider() throws OdaException {
        Object provider = null;
        try {
            provider = this.getPropertyServiceElement().createExecutableExtension(PROVIDER_CLASS_ATTRIBUTE);
        }
        catch (CoreException ex) {
            throw new OdaException((Throwable)ex);
        }
        if (!(provider instanceof IPropertyProvider)) {
            String string = this.getProviderClassName();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new OdaException(Messages.bind((String)Messages.helper_extension_mustImplementInterface, (Object)string, (Object)clazz.getName()));
        }
        return (IPropertyProvider)provider;
    }
}

