/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSet;

public class OdaDataSetMetaData
extends OdaDriverObject
implements IDataSetMetaData {
    protected OdaDataSetMetaData(IDataSetMetaData metadata, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)metadata, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaDataSetMetaData.OdaDataSetMetaData( " + metadata + ", " + connection + " )\t";
        this.logMethodExitWithReturn(context, this);
    }

    private IDataSetMetaData getDataSetMetaData() {
        return (IDataSetMetaData)this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnection getConnection() throws OdaException {
        try {
            this.setContextClassloader();
            OdaConnection odaConnection = this.getOdaConnection();
            return odaConnection;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IDataSetMetaData.getConnection()");
            IConnection iConnection = null;
            return iConnection;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IConnection iConnection = null;
            return iConnection;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet getDataSourceObjects(String catalog, String schema, String object, String version) throws OdaException {
        String context = "OdaDataSetMetaData.getDataSourceObjects( " + catalog + ", " + schema + ", " + object + ", " + version + ")\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IResultSet resultSet = this.getDataSetMetaData().getDataSourceObjects(catalog, schema, object, version);
            OdaResultSet ret = resultSet == null ? null : new OdaResultSet(resultSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn(context, ret);
            OdaResultSet odaResultSet = ret;
            return odaResultSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IDataSetMetaData.getDataSourceObjects( String catalog, String schema, String object, String version )");
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataSourceMajorVersion() throws OdaException {
        try {
            this.setContextClassloader();
            int n = this.getDataSetMetaData().getDataSourceMajorVersion();
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IDataSetMetaData.getDataSourceMajorVersion()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataSourceMinorVersion() throws OdaException {
        try {
            this.setContextClassloader();
            int n = this.getDataSetMetaData().getDataSourceMinorVersion();
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IDataSetMetaData.getDataSourceMinorVersion()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataSourceProductName() throws OdaException {
        try {
            this.setContextClassloader();
            String string = this.getDataSetMetaData().getDataSourceProductName();
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            String string = this.handleUnsupportedOpAndRetEmptyString(uoException, "IDataSetMetaData.getDataSourceProductName()");
            return string;
        }
        catch (RuntimeException rtException) {
            String string = this.handleErrorAndReturnEmptyString(rtException);
            return string;
        }
        catch (OdaException odaException) {
            String string = this.handleErrorAndReturnEmptyString(odaException);
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataSourceProductVersion() throws OdaException {
        try {
            this.setContextClassloader();
            String string = this.getDataSetMetaData().getDataSourceProductVersion();
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            String string = this.handleUnsupportedOpAndRetEmptyString(uoException, "IDataSetMetaData.getDataSourceProductVersion()");
            return string;
        }
        catch (RuntimeException rtException) {
            String string = this.handleErrorAndReturnEmptyString(rtException);
            return string;
        }
        catch (OdaException odaException) {
            String string = this.handleErrorAndReturnEmptyString(odaException);
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSQLStateType() throws OdaException {
        String context = "OdaDataSetMetaData.getSQLStateType()\t";
        this.logMethodCalled("OdaDataSetMetaData.getSQLStateType()\t");
        try {
            this.setContextClassloader();
            int ret = this.getDataSetMetaData().getSQLStateType();
            this.logMethodExitWithReturn("OdaDataSetMetaData.getSQLStateType()\t", ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IDataSetMetaData.getSQLStateType()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultipleOpenResults() throws OdaException {
        String context = "OdaDataSetMetaData.supportsMultipleOpenResults()\t";
        this.logMethodCalled("OdaDataSetMetaData.supportsMultipleOpenResults()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.getDataSetMetaData().supportsMultipleOpenResults();
            this.logMethodExitWithReturn("OdaDataSetMetaData.supportsMultipleOpenResults()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IDataSetMetaData.supportsMultipleOpenResults()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultipleResultSets() throws OdaException {
        String context = "OdaDataSetMetaData.supportsMultipleResultSets()\t";
        this.logMethodCalled("OdaDataSetMetaData.supportsMultipleResultSets()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.checkSupportForMultipleResultSets();
            this.logMethodExitWithReturn("OdaDataSetMetaData.supportsMultipleResultSets()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IDataSetMetaData.supportsMultipleResultSets()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    boolean checkSupportForMultipleResultSets() throws OdaException {
        return this.getDataSetMetaData().supportsMultipleResultSets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsNamedResultSets() throws OdaException {
        String context = "OdaDataSetMetaData.supportsNamedResultSets()\t";
        this.logMethodCalled("OdaDataSetMetaData.supportsNamedResultSets()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.checkSupportForNamedResultSets();
            this.logMethodExitWithReturn("OdaDataSetMetaData.supportsNamedResultSets()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IDataSetMetaData.supportsNamedResultSets()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    boolean checkSupportForNamedResultSets() throws OdaException {
        return this.getDataSetMetaData().supportsNamedResultSets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsNamedParameters() throws OdaException {
        String context = "OdaDataSetMetaData.supportsNamedParameters()\t";
        this.logMethodCalled("OdaDataSetMetaData.supportsNamedParameters()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.checkSupportForNamedParameters();
            this.logMethodExitWithReturn("OdaDataSetMetaData.supportsNamedParameters()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IDataSetMetaData.supportsNamedParameters()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    boolean checkSupportForNamedParameters() throws OdaException {
        return this.getDataSetMetaData().supportsNamedParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsInParameters() throws OdaException {
        String context = "OdaDataSetMetaData.supportsInParameter()\t";
        this.logMethodCalled("OdaDataSetMetaData.supportsInParameter()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.getDataSetMetaData().supportsInParameters();
            this.logMethodExitWithReturn("OdaDataSetMetaData.supportsInParameter()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IDataSetMetaData.supportsInParameters()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOutParameters() throws OdaException {
        String context = "OdaDataSetMetaData.supportsOutParameters()\t";
        this.logMethodCalled("OdaDataSetMetaData.supportsOutParameters()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.getDataSetMetaData().supportsOutParameters();
            this.logMethodExitWithReturn("OdaDataSetMetaData.supportsOutParameters()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IDataSetMetaData.supportsOutParameters()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSortMode() {
        String context = "OdaDataSetMetaData.getSortMode()\t";
        this.logMethodCalled("OdaDataSetMetaData.getSortMode()\t");
        try {
            this.setContextClassloader();
            int sortMode = this.getDataSetMetaData().getSortMode();
            this.logMethodExitWithReturn("OdaDataSetMetaData.getSortMode()\t", sortMode);
            int n = sortMode;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IDataSetMetaData.getSortMode()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        finally {
            this.resetContextClassloader();
        }
        return 0;
    }
}

