/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaBlob;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaClob;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaResultSet
extends OdaDriverObject
implements IResultSet {
    protected OdaResultSet(IResultSet resultSet, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)resultSet, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaResultSet.OdaResultSet( " + resultSet + ", " + connection + " )\t";
        this.logMethodExitWithReturn(context, this);
    }

    protected IResultSet getResultSet() {
        return (IResultSet)this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSetMetaData getMetaData() throws OdaException {
        String context = "OdaResultSet.getMetaData()\t";
        this.logMethodCalled("OdaResultSet.getMetaData()\t");
        try {
            this.setContextClassloader();
            IResultSetMetaData resultSetMetaData = this.getResultSet().getMetaData();
            OdaResultSetMetaData ret = resultSetMetaData == null ? null : new OdaResultSetMetaData(resultSetMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn("OdaResultSet.getMetaData()\t", ret);
            OdaResultSetMetaData odaResultSetMetaData = ret;
            return odaResultSetMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getMetaData()");
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OdaException {
        String context = "OdaResultSet.close()\t";
        this.logMethodCalled("OdaResultSet.close()\t");
        try {
            this.setContextClassloader();
            this.getResultSet().close();
            this.logMethodExit("OdaResultSet.close()\t");
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.close()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int max) throws OdaException {
        String context = "OdaResultSet.setMaxRows( " + max + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.getResultSet().setMaxRows(max);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.setMaxRows( int max )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.logMethodExit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws OdaException {
        String context = "OdaResultSet.next()\t";
        this.logMethodCalled("OdaResultSet.next()\t");
        if (!this.getOdaConnection().isOpen()) {
            OdaException ex = this.newOdaException(Messages.helper_connectionIsInactive);
            return this.handleErrorAndReturnFalse(ex);
        }
        try {
            this.setContextClassloader();
            boolean ret = this.getResultSet().next();
            this.logMethodExitWithReturn("OdaResultSet.next()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IResultSet.next()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws OdaException {
        String context = "OdaResultSet.getRow()\t";
        this.logMethodCalled("OdaResultSet.getRow()\t");
        try {
            this.setContextClassloader();
            int ret = this.getResultSet().getRow();
            this.logMethodExitWithReturn("OdaResultSet.getRow()\t", ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IResultSet.getRow()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int index) throws OdaException {
        String context = "OdaResultSet.getString( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            String ret = this.getResultSet().getString(index);
            this.logMethodExitWithReturn(context, ret);
            String string = ret;
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            String string = this.handleUnsupportedOpAndRetEmptyString(uoException, "IResultSet.getString( int index )");
            return string;
        }
        catch (RuntimeException rtException) {
            String string = this.handleErrorAndReturnEmptyString(rtException);
            return string;
        }
        catch (OdaException odaException) {
            String string = this.handleErrorAndReturnEmptyString(odaException);
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String columnName) throws OdaException {
        String context = "OdaResultSet.getString( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            String ret = this.getResultSet().getString(columnName);
            this.logMethodExitWithReturn(context, ret);
            String string = ret;
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            String string = this.handleUnsupportedOpAndRetEmptyString(uoException, "IResultSet.getString( String columnName )");
            return string;
        }
        catch (RuntimeException rtException) {
            String string = this.handleErrorAndReturnEmptyString(rtException);
            return string;
        }
        catch (OdaException odaException) {
            String string = this.handleErrorAndReturnEmptyString(odaException);
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int index) throws OdaException {
        String context = "OdaResultSet.getInt( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            int ret = this.getResultSet().getInt(index);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IResultSet.getInt( int index )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String columnName) throws OdaException {
        String context = "OdaResultSet.getInt( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            int ret = this.getResultSet().getInt(columnName);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IResultSet.getInt( String columnName )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int index) throws OdaException {
        String context = "OdaResultSet.getDouble( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            double ret = this.getResultSet().getDouble(index);
            this.logMethodExitWithReturn(context, ret);
            double d = ret;
            return d;
        }
        catch (UnsupportedOperationException uoException) {
            double d = this.handleUnsupportedOpAndRetZero(uoException, "IResultSet.getDouble( int index )");
            return d;
        }
        catch (RuntimeException rtException) {
            double d = this.handleErrorAndReturnZero(rtException);
            return d;
        }
        catch (OdaException odaException) {
            double d = this.handleErrorAndReturnZero(odaException);
            return d;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String columnName) throws OdaException {
        String context = "OdaResultSet.getDouble( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            double ret = this.getResultSet().getDouble(columnName);
            this.logMethodExitWithReturn(context, ret);
            double d = ret;
            return d;
        }
        catch (UnsupportedOperationException uoException) {
            double d = this.handleUnsupportedOpAndRetZero(uoException, "IResultSet.getDouble( String columnName )");
            return d;
        }
        catch (RuntimeException rtException) {
            double d = this.handleErrorAndReturnZero(rtException);
            return d;
        }
        catch (OdaException odaException) {
            double d = this.handleErrorAndReturnZero(odaException);
            return d;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int index) throws OdaException {
        String context = "OdaResultSet.getBigDecimal( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            BigDecimal ret = this.getResultSet().getBigDecimal(index);
            this.logMethodExitWithReturn(context, ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getBigDecimal( int index )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        String context = "OdaResultSet.getBigDecimal( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            BigDecimal ret = this.getResultSet().getBigDecimal(columnName);
            this.logMethodExitWithReturn(context, ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getBigDecimal( String columnName )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int index) throws OdaException {
        String context = "OdaResultSet.getDate( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            Date ret = this.getResultSet().getDate(index);
            this.logMethodExitWithReturn(context, ret);
            Date date = ret;
            return date;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getDate( int index )");
            Date date = null;
            return date;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Date date = null;
            return date;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Date date = null;
            return date;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String columnName) throws OdaException {
        String context = "OdaResultSet.getDate( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            Date ret = this.getResultSet().getDate(columnName);
            this.logMethodExitWithReturn(context, ret);
            Date date = ret;
            return date;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getDate( String columnName )");
            Date date = null;
            return date;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Date date = null;
            return date;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Date date = null;
            return date;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int index) throws OdaException {
        String context = "OdaResultSet.getTime( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            Time ret = this.getResultSet().getTime(index);
            this.logMethodExitWithReturn(context, ret);
            Time time = ret;
            return time;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getTime( int index )");
            Time time = null;
            return time;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Time time = null;
            return time;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Time time = null;
            return time;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String columnName) throws OdaException {
        String context = "OdaResultSet.getTime( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            Time ret = this.getResultSet().getTime(columnName);
            this.logMethodExitWithReturn(context, ret);
            Time time = ret;
            return time;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getTime( String columnName )");
            Time time = null;
            return time;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Time time = null;
            return time;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Time time = null;
            return time;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int index) throws OdaException {
        String context = "OdaResultSet.getTimestamp( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            Timestamp ret = this.getResultSet().getTimestamp(index);
            this.logMethodExitWithReturn(context, ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getTimestamp( int index )");
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (OdaException exception) {
            this.handleError(exception);
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(String columnName) throws OdaException {
        String context = "OdaResultSet.getTimestamp( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            Timestamp ret = this.getResultSet().getTimestamp(columnName);
            this.logMethodExitWithReturn(context, ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getTimestamp( String columnName )");
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlob getBlob(int index) throws OdaException {
        String context = "OdaResultSet.getBlob( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IBlob driverBlob = this.getResultSet().getBlob(index);
            IBlob ret = this.createBlobWrapper(driverBlob);
            this.logMethodExitWithReturn(context, ret);
            IBlob iBlob = ret;
            return iBlob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getBlob( int index )");
            IBlob iBlob = null;
            return iBlob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IBlob iBlob = null;
            return iBlob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IBlob iBlob = null;
            return iBlob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlob getBlob(String columnName) throws OdaException {
        String context = "OdaResultSet.getBlob( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IBlob driverBlob = this.getResultSet().getBlob(columnName);
            IBlob ret = this.createBlobWrapper(driverBlob);
            this.logMethodExitWithReturn(context, ret);
            IBlob iBlob = ret;
            return iBlob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getBlob( String columnName )");
            IBlob iBlob = null;
            return iBlob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IBlob iBlob = null;
            return iBlob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IBlob iBlob = null;
            return iBlob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private IBlob createBlobWrapper(IBlob driverBlob) {
        return driverBlob == null ? null : new OdaBlob(driverBlob, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClob getClob(int index) throws OdaException {
        String context = "OdaResultSet.getClob( " + index + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IClob driverClob = this.getResultSet().getClob(index);
            IClob ret = this.createClobWrapper(driverClob);
            this.logMethodExitWithReturn(context, ret);
            IClob iClob = ret;
            return iClob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getClob( int index )");
            IClob iClob = null;
            return iClob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IClob iClob = null;
            return iClob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IClob iClob = null;
            return iClob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClob getClob(String columnName) throws OdaException {
        String context = "OdaResultSet.getClob( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IClob driverClob = this.getResultSet().getClob(columnName);
            IClob ret = this.createClobWrapper(driverClob);
            this.logMethodExitWithReturn(context, ret);
            IClob iClob = ret;
            return iClob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IResultSet.getClob( String columnName )");
            IClob iClob = null;
            return iClob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IClob iClob = null;
            return iClob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IClob iClob = null;
            return iClob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private IClob createClobWrapper(IClob driverClob) {
        return driverClob == null ? null : new OdaClob(driverClob, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws OdaException {
        String context = "OdaResultSet.wasNull()\t";
        this.logMethodCalled("OdaResultSet.wasNull()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.getResultSet().wasNull();
            this.logMethodExitWithReturn("OdaResultSet.wasNull()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IResultSet.wasNull()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws OdaException {
        String context = "OdaResultSet.findColumn( " + columnName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            int ret = this.getResultSet().findColumn(columnName);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IResultSet.findColumn( String columnName )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public String getBigDecimalAsString(int index) throws OdaException {
        String context = "OdaResultSet.getBigDecimalAsString( " + index + " )\t";
        this.logMethodCalled(context);
        BigDecimal decimal = this.getBigDecimal(index);
        String ret = decimal == null ? null : decimal.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getBigDecimalAsString(String columnName) throws OdaException {
        String context = "OdaResultSet.getBigDecimalAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        BigDecimal decimal = this.getBigDecimal(columnName);
        String ret = decimal == null ? null : decimal.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getDateAsString(int index) throws OdaException {
        String context = "OdaResultSet.getDateAsString( " + index + " )\t";
        this.logMethodCalled(context);
        Date date = this.getDate(index);
        String ret = date == null ? null : date.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getDateAsString(String columnName) throws OdaException {
        String context = "OdaResultSet.getDateAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        Date date = this.getDate(columnName);
        String ret = date == null ? null : date.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimeAsString(int index) throws OdaException {
        String context = "OdaResultSet.getTimeAsString( " + index + " )\t";
        this.logMethodCalled(context);
        Time time = this.getTime(index);
        String ret = time == null ? null : time.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimeAsString(String columnName) throws OdaException {
        String context = "OdaResultSet.getTimeAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        Time time = this.getTime(columnName);
        String ret = time == null ? null : time.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimestampAsString(int index) throws OdaException {
        String context = "OdaResultSet.getTimestampAsString( " + index + " )\t";
        this.logMethodCalled(context);
        Timestamp timestamp = this.getTimestamp(index);
        String ret = timestamp == null ? null : timestamp.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimestampAsString(String columnName) throws OdaException {
        String context = "OdaResultSet.getTimestampAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        Timestamp timestamp = this.getTimestamp(columnName);
        String ret = timestamp == null ? null : timestamp.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getClobAsString(int index) throws OdaException {
        String context = "OdaResultSet.getClobAsString( " + index + " )\t";
        this.logMethodCalled(context);
        String ret = this.getClobAsStringImpl(this.getClob(index), context);
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getClobAsString(String columnName) throws OdaException {
        String context = "OdaResultSet.getClobAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        String ret = this.getClobAsStringImpl(this.getClob(columnName), context);
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getInterfaceName() {
        return IResultSet.class.getName();
    }
}

