/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogProcedure;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogSynonym;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogTable;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogUserDefinedFunction;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogView;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.derby.DerbyModelPackage;
import org.eclipse.datatools.modelbase.derby.Synonym;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SchemaImpl;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogSchema
extends SchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257285846544429880L;
    private boolean tablesLoaded = false;
    private boolean synonymLoaded = false;
    private boolean routineLoaded = false;
    private transient ConnectionFilterListener filterListener = new ConnectionFilterListener(){

        public void connectionFilterAdded(String filterKey) {
            DerbyCatalogSchema.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            DerbyCatalogSchema.this.handleFilterChanged(filterKey);
        }
    };

    public synchronized void refresh() {
        this.tablesLoaded = false;
        this.routineLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        if (!this.synonymLoaded) {
            this.synonymLoaded = true;
            DerbyCatalogSchema.loadSynonym(this.getConnection(), super.getTables(), (Schema)this);
        }
        return this.tables;
    }

    public EList getRoutines() {
        if (!this.routineLoaded) {
            this.loadRoutines();
        }
        return this.routines;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getTables();
        } else if (id == 13) {
            this.getRoutines();
        }
        return super.eIsSet(eFeature);
    }

    public NotificationChain basicSetDatabase(Database newDatabase, NotificationChain msgs) {
        ConnectionInfo connectionInfo;
        if (this.database != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.database);
            connectionInfo.removeFilterListener(this.filterListener);
        }
        if (newDatabase != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(newDatabase);
            connectionInfo.addFilterListener(this.filterListener);
        }
        return super.basicSetDatabase(newDatabase, msgs);
    }

    private synchronized void loadTables() {
        boolean hasFilter;
        ConnectionFilter viewFilter;
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        Object[] oldList = tableList.toArray();
        tableList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        ConnectionFilter tableFilter = connectionInfo.getFilter(this.getTableFilterKey());
        if (tableFilter == null) {
            tableFilter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
        }
        if ((viewFilter = connectionInfo.getFilter(this.getViewFilterKey())) == null) {
            viewFilter = connectionInfo.getFilter("DatatoolsViewFilterPredicate");
        }
        String filterStr = "";
        boolean bl = hasFilter = tableFilter != null || viewFilter != null;
        if (hasFilter) {
            filterStr = tableFilter != null ? filterStr + "TABLENAME " + tableFilter.getPredicate() + " AND TABLETYPE='T' OR TABLETYPE='S'" : filterStr + "TABLETYPE='T' OR TABLETYPE='S'";
            if (viewFilter != null) {
                if (filterStr.length() > 0) {
                    filterStr = filterStr + " OR ";
                }
                filterStr = filterStr + "TABLENAME " + viewFilter.getPredicate() + " AND TABLETYPE='V' ";
            } else {
                filterStr = filterStr + " OR TABLETYPE='V' ";
            }
            filterStr = " AND (" + filterStr;
            filterStr = filterStr + ") ";
        }
        String query = "SELECT TABLENAME,TABLETYPE FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + this.getName() + "'";
        if (hasFilter) {
            query = query + filterStr;
        }
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                Object table;
                String tableName = r.getString("TABLENAME");
                String type = r.getString("TABLETYPE");
                EClass metaclass = null;
                if (type.equals("T") || type.equals("S")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getPersistentTable();
                } else if (type.equals("V")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getViewTable();
                }
                Object element = DerbyCatalogSchema.findElement(oldList, tableName, metaclass);
                if (element != null) {
                    table = (Table)element;
                    tableList.add(table);
                    ((ICatalogObject)table).refresh();
                    continue;
                }
                if (type.equals("T") || type.equals("S")) {
                    table = new DerbyCatalogTable();
                } else {
                    if (!type.equals("V")) continue;
                    table = new DerbyCatalogView();
                }
                table.setName(tableName);
                tableList.add(table);
            }
            this.tablesLoaded = true;
            r.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.eSetDeliver(deliver);
    }

    public static void loadSynonym(Connection connection, EList tableList, Schema schema) {
        String query = "SELECT TABLENAME,TABLETYPE FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + schema.getName() + "' AND TABLETYPE='A'";
        Object[] oldList = tableList.toArray();
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(schema.getDatabase());
        ConnectionFilter synonymFilter = connectionInfo.getFilter(schema.getName() + "::" + "DatatoolsTableFilterPredicate");
        if (synonymFilter == null) {
            synonymFilter = connectionInfo.getFilter("DatatoolsAliasFilterPredicate");
        }
        String filterStr = "";
        if (synonymFilter != null) {
            filterStr = filterStr + "A.SYNONYM_NAME " + synonymFilter.getPredicate();
            filterStr = " AND (" + filterStr;
            filterStr = filterStr + ") ";
            query = query + filterStr;
        }
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                Object synonym;
                EClass metaclass;
                String synonymName = r.getString("TABLENAME");
                Object element = DerbyCatalogSchema.findElement(oldList, synonymName, metaclass = DerbyModelPackage.eINSTANCE.getSynonym());
                if (element != null) {
                    synonym = (Synonym)element;
                    ((ICatalogObject)synonym).refresh();
                } else {
                    synonym = new DerbyCatalogSynonym();
                    synonym.setName(synonymName);
                }
                tableList.add(synonym);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private synchronized void loadRoutines() {
        if (this.routineLoaded) {
            return;
        }
        EList routineList = super.getRoutines();
        Object[] oldList = routineList.toArray();
        routineList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        ConnectionFilter spFilter = connectionInfo.getFilter(this.getSPFilterKey());
        if (spFilter == null) {
            spFilter = connectionInfo.getFilter("DatatoolsSPFilterPredicate");
        }
        String filterStr = spFilter == null ? new String() : " AND " + spFilter.getPredicate();
        try {
            String query = "SELECT ALIAS,ALIASTYPE FROM SYS.SYSALIASES A,SYS.SYSSCHEMAS B WHERE A.ALIASTYPE IN ('P','F') AND A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + this.getName() + "'" + filterStr;
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                Object routine;
                String routineName = r.getString("ALIAS");
                String type = r.getString("ALIASTYPE");
                EClass metaclass = null;
                if (type.equals("P")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getProcedure();
                } else if (type.equals("F")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
                }
                Object element = DerbyCatalogSchema.findElement(oldList, routineName, metaclass);
                if (element != null) {
                    routine = (Routine)element;
                    ((ICatalogObject)routine).refresh();
                } else {
                    if (type.equals("P")) {
                        routine = new DerbyCatalogProcedure();
                    } else {
                        if (!type.equals("F")) continue;
                        routine = new DerbyCatalogUserDefinedFunction();
                    }
                    routine.setName(routineName);
                }
                routineList.add(routine);
            }
            this.routineLoaded = true;
            r.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.eSetDeliver(deliver);
    }

    protected static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        for (int i = 0; i < list.length; ++i) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (!sqlObject.getName().equals(name) || sqlObject.eClass() != metaclass) continue;
            object = list[i];
            break;
        }
        return object;
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.routineLoaded && (filterKey.equals(this.getSPFilterKey()) || "DatatoolsSPFilterPredicate".equals(filterKey) && conInf != null && conInf.getFilter(this.getSPFilterKey()) == null)) {
            this.routineLoaded = false;
            refresh = true;
        }
        if (this.tablesLoaded && (filterKey.equals(this.getTableFilterKey()) || filterKey.equals(this.getViewFilterKey()) || conInf != null && "DatatoolsTableFilterPredicate".equals(filterKey) && conInf.getFilter(this.getTableFilterKey()) == null || "DatatoolsViewFilterPredicate".equals(filterKey) && conInf.getFilter(this.getViewFilterKey()) == null)) {
            this.tablesLoaded = false;
            this.synonymLoaded = false;
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    private String getTableFilterKey() {
        return this.getName() + "::" + "DatatoolsTableFilterPredicate";
    }

    private String getSPFilterKey() {
        return this.getName() + "::" + "DatatoolsSPFilterPredicate";
    }

    private String getViewFilterKey() {
        return this.getName() + "::" + "DatatoolsViewFilterPredicate";
    }
}

