/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.impl.DatabaseImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogDatabase
extends DatabaseImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257562914901669687L;
    private Connection connection;
    private boolean schemasLoaded = false;
    private transient ConnectionFilterListener filterListener;

    public DerbyCatalogDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    public synchronized void refresh() {
        if (this.schemasLoaded) {
            this.schemasLoaded = false;
            this.schemas.clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public EList getSchemas() {
        if (!this.schemasLoaded) {
            this.loadSchemas();
        }
        return this.schemas;
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getSchemas();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadSchemas() {
        if (this.schemasLoaded) {
            return;
        }
        EList schemaList = super.getSchemas();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
            ConnectionFilter filter = connectionInfo.getFilter(this.getFilterKey());
            if (filter == null) {
                filter = connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
            }
            String query = "SELECT SCHEMANAME FROM SYS.SYSSCHEMAS";
            if (filter != null) {
                query = query + " WHERE SCHEMANAME " + filter.getPredicate();
            }
            Statement s = this.connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String schemaName = r.getString(1);
                DerbyCatalogSchema schema = new DerbyCatalogSchema();
                schema.setName(schemaName);
                schemaList.add((Object)schema);
            }
            this.schemasLoaded = true;
            r.close();
            s.close();
            if (this.filterListener == null) {
                this.filterListener = new FilterListener();
                connectionInfo.addFilterListener(this.filterListener);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private void handleFilterChanged(String filterKey) {
        ConnectionInfo conInf;
        if (!this.schemasLoaded) {
            return;
        }
        if (filterKey.equals(this.getFilterKey())) {
            this.refresh();
        } else if ("DatatoolsSchemaFilterPredicate".equals(filterKey) && (conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this)) != null && conInf.getFilter(this.getFilterKey()) == null) {
            this.refresh();
        }
    }

    private String getFilterKey() {
        return this.getName() + "::" + "DatatoolsSchemaFilterPredicate";
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private FilterListener() {
        }

        public void connectionFilterAdded(String filterKey) {
            DerbyCatalogDatabase.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            DerbyCatalogDatabase.this.handleFilterChanged(filterKey);
        }
    }
}

