/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.ddl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlBuilder;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlBuilder101;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlScript;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGenerationOptions;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EObject;

public final class DerbyDdlGenerator
implements DDLGenerator,
IExecutableExtension {
    private String product;
    private String version;
    private EngineeringOption[] options = null;
    private EngineeringOptionCategory[] categories = null;
    private DerbyDdlBuilder builder = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
        this.builder = this.version.equals("10.1") ? new DerbyDdlBuilder101() : new DerbyDdlBuilder();
    }

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        String[] statements = this.createSQLObjects(elements, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), progressMonitor);
        if (this.generateDropStatement()) {
            int i;
            String[] drop = this.dropSQLObjects(elements, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), progressMonitor);
            String[] temp = statements;
            statements = new String[temp.length + drop.length];
            for (i = 0; i < drop.length; ++i) {
                statements[i] = drop[i];
            }
            for (i = 0; i < temp.length; ++i) {
                statements[i + drop.length] = temp[i];
            }
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
    }

    private String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        DerbyDdlScript script = new DerbyDdlScript();
        if (this.builder == null) {
            this.builder = new DerbyDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof BaseTable) {
                if (!this.generateTables() || (statement = this.builder.createTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews() || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures() || (statement = this.builder.createProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions() || (statement = this.builder.createUserDefinedFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers() || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateTables() || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generateTables() || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateTables() || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes() || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateIndexStatement(statement);
        }
        return script.getStatements();
    }

    private String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        DerbyDdlScript script = new DerbyDdlScript();
        if (this.builder == null) {
            this.builder = new DerbyDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof BaseTable) {
                if (!this.generateTables() || (statement = this.builder.dropTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews() || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures() || (statement = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions() || (statement = this.builder.dropFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers() || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateTables() || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generateTables() || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateTables() || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes() || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropIndexStatement(statement);
        }
        return script.getStatements();
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
            Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
            EngineeringOption[] temp = GenericDdlGenerationOptions.createDDLGenerationOptions((EngineeringOptionCategory[])this.getOptionCategories());
            for (int i = 0; i < temp.length; ++i) {
                optionVec.add(temp[i]);
            }
            EngineeringOptionCategory additional_element = null;
            for (int i = 0; i < this.categories.length; ++i) {
                if (!this.categories[i].getId().equals("GENERATE_ELEMENTS")) continue;
                additional_element = this.categories[i];
            }
            optionVec.add(new EngineeringOption("GENERATE_STOREDPROCEDURES", resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_FUNCTIONS", resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"), true, additional_element));
            this.options = new EngineeringOption[optionVec.size()];
            optionVec.copyInto(this.options);
        }
        return this.options;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    private final boolean generateQuotedIdentifiers() {
        return this.getOptions()[1].getBoolean();
    }

    private final boolean generateFullyQualifiedNames() {
        return this.getOptions()[0].getBoolean();
    }

    private boolean generateDropStatement() {
        return this.getOptions()[2].getBoolean();
    }

    private boolean generateCreateStatement() {
        return this.getOptions()[3].getBoolean();
    }

    public final boolean generateTables() {
        return this.getOptions()[4].getBoolean();
    }

    public boolean generateIndexes() {
        return this.getOptions()[5].getBoolean();
    }

    public boolean generateViews() {
        return this.getOptions()[6].getBoolean();
    }

    public boolean generateTriggers() {
        return this.getOptions()[7].getBoolean();
    }

    public boolean generateStoredProcedures() {
        return this.getOptionValue("GENERATE_STOREDPROCEDURES");
    }

    public boolean generateFunctions() {
        return this.getOptionValue("GENERATE_FUNCTIONS");
    }

    private boolean getOptionValue(String optionID) {
        boolean ret = false;
        for (int i = 0; i < this.getOptions().length; ++i) {
            EngineeringOption option = this.options[i];
            if (!option.getId().equals(optionID)) continue;
            ret = option.getBoolean();
            break;
        }
        return ret;
    }

    private Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        for (int i = 0; i < elements.length; ++i) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
        }
        return s;
    }
}

