/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.ddl;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlBuilder;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;

public class DerbyDdlBuilder101
extends DerbyDdlBuilder {
    protected static final String NO_CASCADE = "NO CASCADE";

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = statement + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = statement + "NO CASCADE BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = statement + "INSTEAD OF";
        }
        statement = statement + " ";
        if (trigger.isDeleteType()) {
            statement = statement + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = statement + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = statement + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = statement + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = statement + column.getName();
                    if (!it.hasNext()) continue;
                    statement = statement + ", ";
                }
            }
        }
        statement = statement + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        String newTable = trigger.getNewTable();
        String oldTable = trigger.getOldTable();
        if (newRow != null && newRow.length() != 0) {
            statement = statement + "REFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = statement + "REFERENCING OLD AS " + oldRow + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? statement + "FOR EACH ROW MODE DB2SQL" + NEWLINE : statement + "FOR EACH STATEMENT MODE DB2SQL" + NEWLINE;
        Iterator it = trigger.getActionStatement().iterator();
        while (it.hasNext()) {
            SQLStatement s = (SQLStatement)it.next();
            statement = statement + s.getSQL();
        }
        return statement;
    }
}

