/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.derby.DerbyPlugin;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogColumn;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogParameter;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.routines.impl.UserDefinedFunctionImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogUserDefinedFunction
extends UserDefinedFunctionImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3905244528465163826L;
    private boolean parameterLoaded = false;
    private boolean loaded = false;

    public void refresh() {
        if (this.parameterLoaded) {
            this.parameters.clear();
            this.parameterLoaded = false;
        }
        this.loaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getParameters() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    public String getLanguage() {
        if (!this.loaded) {
            this.load();
        }
        return this.language;
    }

    public String getParameterStyle() {
        if (!this.loaded) {
            this.load();
        }
        return this.parameterStyle;
    }

    public DataAccess getSqlDataAccess() {
        if (!this.loaded) {
            this.load();
        }
        return this.sqlDataAccess;
    }

    public Source getSource() {
        if (!this.loaded) {
            this.load();
        }
        return super.getSource();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 15) {
            this.getParameters();
        } else if (id == 6) {
            this.getLanguage();
        } else if (id == 7) {
            this.getParameterStyle();
        } else if (id == 9) {
            this.getSqlDataAccess();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DerbyCatalogUserDefinedFunction.loadParameters(this.getConnection(), super.getParameters(), this);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.parameterLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadParameters(Connection connection, EList parameterList, DerbyCatalogUserDefinedFunction function) throws SQLException {
        Database database = function.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet r = metaData.getProcedureColumns(null, function.getSchema().getName(), function.getName(), null);
        try {
            while (r.next()) {
                boolean isTableFunction = false;
                String schemaName = r.getString(2);
                String functionName = r.getString(3);
                String name = r.getString(4);
                short columntype = r.getShort(5);
                if (columntype == 3) {
                    isTableFunction = true;
                }
                PredefinedDataType type = null;
                String typeName = r.getString(7);
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition != null) {
                    EStructuralFeature feature;
                    int length;
                    type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        length = r.getInt(9);
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(length));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        int length2 = r.getInt(8);
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)new Integer(length2));
                    }
                    if (typeDefinition.isScaleSupported()) {
                        length = r.getInt(10);
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(length));
                    }
                }
                if (isTableFunction) {
                    RoutineResultTable resultTable = function.getReturnTable();
                    if (resultTable == null) {
                        resultTable = (RoutineResultTable)factory.create(SQLRoutinesPackage.eINSTANCE.getRoutineResultTable());
                        function.setReturnTable(resultTable);
                    }
                    DerbyCatalogColumn column = new DerbyCatalogColumn();
                    column.setName(name);
                    column.setDescription(r.getString(13));
                    column.setDataType((DataType)type);
                    resultTable.getColumns().add((Object)column);
                    continue;
                }
                DerbyCatalogParameter parameter = new DerbyCatalogParameter();
                parameter.setName(name);
                if (columntype == 2) {
                    parameter.setMode(ParameterMode.INOUT_LITERAL);
                } else if (columntype == 4) {
                    parameter.setMode(ParameterMode.OUT_LITERAL);
                } else if (columntype == 1) {
                    parameter.setMode(ParameterMode.IN_LITERAL);
                }
                parameter.setDescription(r.getString(13));
                parameter.setDataType((DataType)type);
                if (columntype == 5) {
                    function.setReturnScaler((Parameter)parameter);
                    continue;
                }
                parameterList.add((Object)parameter);
            }
            r.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            String sql = "SELECT ALIAS,JAVACLASSNAME,ALIASINFO FROM SYS.SYSALIASES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME = ?  AND A.ALIAS = ?";
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, this.getSchema().getName());
            stmt.setString(2, this.getName());
            ResultSet r = stmt.executeQuery();
            while (r.next()) {
                this.language = "JAVA";
                this.parameterStyle = "JAVA";
                String javaClassName = r.getString(2);
                Object aliasInfo = r.getObject(3);
                this.setRestOfMetaData(javaClassName, aliasInfo);
            }
            r.close();
            stmt.close();
        }
        catch (Exception e) {
            Status status = new Status(4, DerbyPlugin.getDefault().getBundle().getSymbolicName(), 4, "###Error..org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogProcedure.setRestOfMetaData", (Throwable)e);
            DerbyPlugin.getDefault().getLog().log((IStatus)status);
        }
        this.eSetDeliver(deliver);
    }

    protected void setRestOfMetaData(String javaClassName, Object aliasInfo) {
        try {
            String aliasInfoString = aliasInfo.toString();
            this.loadSource(aliasInfoString);
            this.setSqlDataAccess(aliasInfoString);
            int index = aliasInfoString.indexOf("(");
            String methodName = aliasInfoString.substring(0, index);
            this.setExternalName(javaClassName + "." + methodName);
        }
        catch (Exception e) {
            Status status = new Status(4, DerbyPlugin.getDefault().getBundle().getSymbolicName(), 4, "###Error..org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogProcedure.load", (Throwable)e);
            DerbyPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void setSqlDataAccess(String aliasInfo) {
        int index = aliasInfo.indexOf("NO SQL");
        if (index != -1) {
            this.setSqlDataAccess(DataAccess.NO_SQL_LITERAL);
        } else {
            index = aliasInfo.indexOf("MODIFIES SQL DATA");
            if (index != -1) {
                this.setSqlDataAccess(DataAccess.MODIFIES_SQL_DATA_LITERAL);
            } else {
                index = aliasInfo.indexOf("CONTAINS SQL");
                if (index != -1) {
                    this.setSqlDataAccess(DataAccess.CONTAINS_SQL_LITERAL);
                } else {
                    index = aliasInfo.indexOf("READS SQL DATA");
                    if (index != -1) {
                        this.setSqlDataAccess(DataAccess.READS_SQL_DATA_LITERAL);
                    }
                }
            }
        }
    }

    private void loadSource(String aliasInfo) {
        int index = aliasInfo.indexOf("(");
        String body = aliasInfo.substring(index);
        body = body.replaceAll("IN ", "");
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        DataModelElementFactory factory = definition.getDataModelElementFactory();
        Source s = (Source)factory.create(SQLRoutinesPackage.eINSTANCE.getSource());
        s.setBody(body);
        this.setSource(s);
    }
}

