/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.internal.derby.connection.DerbyShutdownService;
import org.osgi.framework.BundleContext;

public class DerbyPlugin
extends Plugin {
    private static DerbyPlugin plugin;
    protected DerbyShutdownService shutdownService;

    public DerbyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.shutdownService = new DerbyShutdownService();
        File dir = this.getStateLocation().append("sample").toFile();
        if (!dir.exists()) {
            String location = this.getBundle().getLocation();
            location = location.substring(location.indexOf(64) + 1);
            File f = new File(location);
            f = new File(f, "sample");
            try {
                this.copyDir(f, dir);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownService.dispose();
        super.stop(context);
    }

    public static DerbyPlugin getDefault() {
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File source, File dest) throws IOException {
        AbstractInterruptibleChannel out;
        block5: {
            FileChannel in = null;
            out = null;
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                long size = in.size();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
                Object var9_7 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
    }

    private void copyDir(File source, File dest) throws IOException {
        dest.mkdir();
        File[] files = source.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File target = new File(dest, file.getName());
            if (file.isDirectory()) {
                this.copyDir(file, target);
                continue;
            }
            this.copyFile(file, target);
        }
    }
}

