#
# Copyright (c) 2021 Contributors to the Eclipse Foundation
#
# This program and the accompanying materials are made
# available under the terms of the Eclipse Public License 2.0
# which is available at https://www.eclipse.org/legal/epl-2.0/
#
# SPDX-License-Identifier: EPL-2.0
#

import json
from typing import List, Optional
if not 'ReachabilityGraph' in globals():
    from reachability_graph import ReachabilityGraph
if not 'VerificationReport' in globals():
    from verification_report import VerificationReport

def execute(depth: int, home_states: List[List[str]], generateVerificationReport: bool, clientServerNetQueueSize: Optional[int]):
    n = net()
    rg = ReachabilityGraph(n, depth, 'all')
    vr = VerificationReport(n, rg, home_states, clientServerNetQueueSize) if generateVerificationReport else None
    print(json.dumps({
        'verification_report': vr.to_json() if vr != None else None, 
        'reachability_graph': rg.to_json(),
        'client_server_net': vr.client_server_net.serialize() if vr != None and vr.client_server_net != None else None
    }))