# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class SecurityTask(Resource):
    """Security task that we recommend to do in order to strengthen security.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar state: State of the task (Active, Resolved etc.)
    :vartype state: str
    :ivar creation_time_utc: The time this task was discovered in UTC
    :vartype creation_time_utc: datetime
    :param security_task_parameters:
    :type security_task_parameters:
     ~azure.mgmt.security.models.SecurityTaskParameters
    :ivar last_state_change_time_utc: The time this task's details were last
     changed in UTC
    :vartype last_state_change_time_utc: datetime
    :ivar sub_state: Additional data on the state of the task
    :vartype sub_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'creation_time_utc': {'readonly': True},
        'last_state_change_time_utc': {'readonly': True},
        'sub_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time_utc': {'key': 'properties.creationTimeUtc', 'type': 'iso-8601'},
        'security_task_parameters': {'key': 'properties.securityTaskParameters', 'type': 'SecurityTaskParameters'},
        'last_state_change_time_utc': {'key': 'properties.lastStateChangeTimeUtc', 'type': 'iso-8601'},
        'sub_state': {'key': 'properties.subState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityTask, self).__init__(**kwargs)
        self.state = None
        self.creation_time_utc = None
        self.security_task_parameters = kwargs.get('security_task_parameters', None)
        self.last_state_change_time_utc = None
        self.sub_state = None
