# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Rectangle(Model):
    """Describes the properties of a rectangular window applied to the input media
    before processing it.

    :param left: The number of pixels from the left-margin. This can be
     absolute pixel value (e.g 100), or relative to the size of the video (For
     example, 50%).
    :type left: str
    :param top: The number of pixels from the top-margin. This can be absolute
     pixel value (e.g 100), or relative to the size of the video (For example,
     50%).
    :type top: str
    :param width: The width of the rectangular region in pixels. This can be
     absolute pixel value (e.g 100), or relative to the size of the video (For
     example, 50%).
    :type width: str
    :param height: The height of the rectangular region in pixels. This can be
     absolute pixel value (e.g 100), or relative to the size of the video (For
     example, 50%).
    :type height: str
    """

    _attribute_map = {
        'left': {'key': 'left', 'type': 'str'},
        'top': {'key': 'top', 'type': 'str'},
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Rectangle, self).__init__(**kwargs)
        self.left = kwargs.get('left', None)
        self.top = kwargs.get('top', None)
        self.width = kwargs.get('width', None)
        self.height = kwargs.get('height', None)
