# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExportDevicesRequest(Model):
    """Use to provide parameters when requesting an export of all devices in the
    IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param export_blob_container_uri: Required. The export blob container URI.
    :type export_blob_container_uri: str
    :param exclude_keys: Required. The value indicating whether keys should be
     excluded during export.
    :type exclude_keys: bool
    """

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'exportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'excludeKeys', 'type': 'bool'},
    }

    def __init__(self, *, export_blob_container_uri: str, exclude_keys: bool, **kwargs) -> None:
        super(ExportDevicesRequest, self).__init__(**kwargs)
        self.export_blob_container_uri = export_blob_container_uri
        self.exclude_keys = exclude_keys
