% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_meeting_details.R
\name{get_meeting_details}
\alias{get_meeting_details}
\title{Get Meeting Details}
\usage{
get_meeting_details(meeting_id, account_id, client_id, client_secret)
}
\arguments{
\item{meeting_id}{Zoom Meeting ID (from list_meetings).}

\item{account_id}{Account ID granted by the Zoom developer app.}

\item{client_id}{Client ID granted by the Zoom developer app.}

\item{client_secret}{Client secret granted by the Zoom developer app.}
}
\value{
A data frame with the metadata about a meeting. The \code{type}
column contains integer codes describing the meeting structure/format,
while \code{meeting_format_label} provides human-readable descriptions:
\itemize{
  \item 1 = Instant meeting
  \item 2 = Scheduled meeting
  \item 3 = Recurring meeting (no fixed time)
  \item 8 = Recurring meeting (fixed time)
  \item 10 = Screen share only meeting
}
}
\description{
Get metadata about a single meeting including participant count,
duration, and other meeting statistics.
}
\details{
This function retrieves basic meeting metadata. For more comprehensive
meeting analytics and participant data, users with Pro+ Zoom accounts
can access the Reports API endpoints which provide enhanced meeting
details and participant information.
}
\examples{
\dontrun{
dat <- get_meeting_details(meeting_id = "81753923023",
  your_account_id,
  your_client_id,
  your_client_secret)
}
}
\seealso{
Official Zoom API documentation:
\url{https://developers.zoom.us/docs/api/meetings/#tag/meetings/get/meetings/\{meetingId\}}
}
