% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.msgdm}
\alias{Zeta.msgdm}
\title{Multi-site generalised dissimilarity modelling for a set of environmental variables and distances}
\usage{
Zeta.msgdm(
  data.spec,
  data.env,
  xy = NULL,
  data.spec.pred = NULL,
  order = 1,
  sam = 1000,
  reg.type = "ispline",
  family = NULL,
  method.glm = "glm.fit.cons",
  cons = -1,
  cons.inter = NULL,
  confint.level = 0.95,
  bs = "mpd",
  kn = -1,
  order.ispline = 2,
  kn.ispline = 1,
  distance.type = "Euclidean",
  dist.custom = NULL,
  rescale = FALSE,
  rescale.pred = TRUE,
  method = "mean",
  normalize = "Simpson",
  silent = FALSE,
  empty.row = 0,
  control = list(),
  glm.init = FALSE
)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{data.env}{Site-by-variable data frame, with sites as rows and environmental variables as columns.}

\item{xy}{Site coordinates, to account for distances between sites.}

\item{data.spec.pred}{Site-by-species presence-absence data frame or list of data frames, with sites as rows and species as columns, for which zeta diversity will be computed and used as a predictor of the zeta diversity of \code{data.spec}.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta diversity is computed.}

\item{reg.type}{Type of regression used in the multi-site generalised dissimilarity modelling. Default is "\code{ispline}" for I-spline models (forcing monotonic decline), as recommended in generalised dissimilarity modelling by Ferrier \emph{et al}. (2007). Other options are "\code{glm}" for generalised linear models, "\code{ngls}" for negative linear models, "\code{gam}" for generalised additive models, "\code{scam}" for shape constrained additive models (with monotonic decreasing by default), and .}

\item{family}{A description of the error distribution and link function to be used in the \code{glm}, \code{gam} and \code{scam} models used in the different types of regression (see \code{\link[stats]{family}} in package \code{stats} for details of family functions). Default is \code{binomial("log")} if Jaccard, Sorensen or Simpson similarity indices are used (see parameter \code{normalize}), or \code{gaussian} for raw zeta values.}

\item{method.glm}{Method used in fitting the generalised linear model. The default method \cr "glm.fit.cons" is an adaptation of method \code{glm.fit2} from package \code{glm2} using a constrained least squares regression (default is negative coefficients) in the reweighted least squares. Another option is "glm.fit2", which calls \code{glm.fit2}; see help documentation for glm.fit2 in package \code{glm2}.}

\item{cons}{type of constraint in the glm if \code{method.glm = "glm.fit.cons"}. Default is -1 for negative coefficients on the predictors. The other option is 1 for positive coefficients on the predictors.}

\item{cons.inter}{type of constraint for the intercept. If no value is specified, \code{cons.inter} is set to -1 (for negative intercept) for binomial family, or to 1 (for positive intercept) for Gaussian family}

\item{confint.level}{Percentage for the confidence intervals of the coefficients from the generalised linear models.}

\item{bs}{A two-letter character string indicating the (penalized) smoothing basis to use in the scam model. Default is "\code{mpd}" for monotonic decreasing splines. see \code{\link[mgcv]{smooth.terms}} in package \code{mgcv} for an overview of what is available.}

\item{kn}{Number of knots in the GAM and SCAM. Default is -1 for determining kn automatically using Generalized Cross-validation.}

\item{order.ispline}{Order of the I-spline.}

\item{kn.ispline}{Number of knots in the I-spline.}

\item{distance.type}{Method to compute distance. Default is "\code{Euclidean}", for Euclidean distance. The other options are (i) "\code{ortho}" for orthodromic distance, if xy correspond to longitudes and latitudes (orthodromic distance is computed using the \code{geodist} function from package \code{geodist}); and (ii) "\code{custom}", in which case the user must provide a distance matrix for \code{dist.custom}.}

\item{dist.custom}{Distance matrix provided by the user when \code{distance.type} = \code{"custom"}.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by the total number of species in the dataset, to get a range of values between 0 and 1. Has no effect if \code{normalize} != \code{FALSE}.}

\item{rescale.pred}{Boolean value (TRUE or FALSE) indicating if the spatial distances and differences in environmental variables should be rescaled between 0 and 1.}

\item{method}{Name of a function (as a string) indicating how to combine the pairwise differences and distances for more than 3 sites. It can be a basic R-function such as "\code{mean}" or "\code{max}", but also a custom function.}

\item{normalize}{Indicates if the zeta values for each sample should be divided by the minimum number of species in the sites of this specific sample \cr (\code{normalize = "Simpson"}) (default), by the total number of species for this specific sample (\code{normalize = "Jaccard"}), or by the average number of species per site for this specific sample (\code{normalize = "Sorensen"}). Value must be set to \code{FALSE} to indicate that no normalization must be performed and raw zeta values should be used.}

\item{silent}{Boolean value (TRUE or FALSE) indicating if warnings must be printed.}

\item{empty.row}{Determines how to handle empty rows, i.e. sites with no species. Such sites can cause underestimations of zeta diversity, and computation errors for the normalized version of zeta due to divisions by 0. Options are "\code{empty}" to let the data untreated, "\code{remove}" to remove the empty rows, 0 to set the normalized zeta to 0 when zeta is divided by 0 during normalization (sites share no species, so are completely dissimilar), and 1 to set the normalized zeta to 1 when zeta is divided by 0 during normalization (i.e. sites are perfectly similar).}

\item{control}{As for \code{\link[stats]{glm}}.}

\item{glm.init}{Boolean value, indicating if the initial parameters for fitting the glm with constraint on the coefficients signs for \code{reg.type == "ispline"} should be initialised based on the correlation coefficients betwen the zeta values and the environmental difference or distance. \code{glm.init = TRUE} helps preventing the error message: \code{error: cannot find valid starting values:} \cr \code{please specify some}.}
}
\value{
\code{Zeta.msgdm} returns a list whose component vary depending on the regression technique. The list can contain the following components:

\item{val}{Vector of zeta values used in the MS-GDM.}

\item{predictors}{Data frame of the predictors used in the MS-GDM.}

\item{range.min}{Vector containing the minimum values of the numeric variables, used for rescaling the variables between 0 and 1 for I-splines (see Details).}

\item{range.max}{Vector containing the maximum values of the numeric variables, used for rescaling the variables between 0 and 1 for I-splines (see Details).}

\item{rescale.factor}{Factor by which the predictors were divided if \code{rescale.pred = TRUE} and \cr\code{order>1}.}

\item{order.ispline}{The value of the original parameter, to be used in \code{Plot.ispline}.}

\item{kn.ispline}{The value of the original parameter, to be used in \code{Plot.ispline}.}

\item{model}{An object whose class depends on the type of regression (\code{glm}, \code{nnnpls}, \code{gam} or \code{scam}; I-splines return and object of class \code{glm}), corresponding to the regression over distance for the number of assemblages or sites specified in \code{order}.}

\item{confint}{The confidence intervals for the coefficients from generalised linear models with no constraint. \code{confint} is not generated for the other types of regression.}

\item{vif}{The variance inflation factors for all the variables for the generalised linear regression. \code{vif} is not generated for the other types of regression.}
}
\description{
Computes a regression model of zeta diversity for a given order (number of assemblages or sites) against a set of environmental variables and distances between sites. The different regression models available are generalised linear models, generalised linear models with negative constraints, generalised additive models, shape constrained additive models, and I-splines.
}
\details{
The environmental variables can be numeric or factorial.

If \code{order = 1}, the variables are used as such in the regression, and factorial variables must be dummy for the output of the regression to be interpretable.

For numeric variables, if \code{order>1} the pairwise difference between sites is computed and combined according to \code{method}. For factorial variables, the distance corresponds to the number of unique values over the number of assemblages of sites specified by \code{order}.

If \code{xy = NULL}, \code{Zeta.msgdm} only uses environmental variables in the regression. Otherwise, it also computes and uses euclidian distance (average or maximum distance between multiple sites, depending on the parameters \code{method}) as an explanatory variable.

If \code{rescale.pred = TRUE}, zeta is regressed against the differences of values of the environmental variables divided by the maximum difference for each variable, to be rescaled between 0 and 1. If \code{!is.null(xy)}, distances between sites are also divided by the maximum distance. If \code{order = 1}, the variables are transformed by first subtracting their minimum value, and dividing by the difference of their maximum and minimum values.

If \code{reg.type = "ispline"}, the variables are rescaled between 0 and 1 prior to computing the I-splines by subtracting their minimum value, and dividing by the difference of their maximum and minimum values.
}
\examples{
utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[1:2]
data.spec.bird <- bird.spec.coarse[3:193]
utils::data(bird.env.coarse)
data.env.bird <- bird.env.coarse[,3:9]

zeta.glm <- Zeta.msgdm(data.spec.bird, data.env.bird, sam = 100, order = 3,
                               reg.type = "glm")
zeta.glm
dev.new()
graphics::plot(zeta.glm$model)

zeta.ngls <- Zeta.msgdm(data.spec.bird, data.env.bird, xy.bird, sam = 100, order = 3,
    reg.type = "ngls", rescale = TRUE)
zeta.ngls

##########

utils::data(Marion.species)
xy.marion <- Marion.species[1:2]
data.spec.marion <- Marion.species[3:33]
utils::data(Marion.env)
data.env.marion <- Marion.env[3]

zeta.gam <- Zeta.msgdm(data.spec.marion, data.env.marion, sam = 100, order = 3,
    reg.type = "gam")
zeta.gam
dev.new()
graphics::plot(zeta.gam$model)

zeta.ispline <- Zeta.msgdm(data.spec.marion, data.env.marion, xy.marion, sam = 100,
    order = 3, normalize = "Jaccard", reg.type = "ispline")
zeta.ispline

zeta.ispline.r <- Return.ispline(zeta.ispline, data.env.marion, distance = TRUE)
zeta.ispline.r

dev.new()
Plot.ispline(isplines = zeta.ispline.r, distance = TRUE)

dev.new()
Plot.ispline(msgdm = zeta.ispline, data.env = data.env.marion, distance = TRUE)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Ferrier, S., Manion, G., Elith, J., & Richardson, K. (2007). Using generalized dissimilarity modelling to analyse and predict patterns of beta diversity in regional biodiversity assessment. \emph{Diversity and Distributions}, 13(3), 252-264.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}, \code{\link{Predict.msgdm}},

\code{\link{Ispline}}
}
