% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson.R
\name{read_geojson_str}
\alias{read_geojson_str}
\alias{read_geojson_file}
\title{Load GeoJSON as \code{sf} object}
\usage{
read_geojson_str(str, opts = list(), ..., json_opts = list())

read_geojson_file(filename, opts = list(), ..., json_opts = list())
}
\arguments{
\item{str}{Single string containing GeoJSON.}

\item{opts}{Named list of GeoJSON-specific options. Usually created
with \code{opts_read_geojson()}.
Default: empty \code{list()} to use the default options.}

\item{...}{Any extra named options override those in GeoJSON-specific options
- \code{opts}}

\item{json_opts}{Named list of vanilla JSON options as used by \code{read_json_str()}.
This is usually created with \code{opts_read_json()}.  Default value is
an empty \code{list()} which means to use all the default JSON parsing
options which is usually the correct thing to do when reading GeoJSON.}

\item{filename}{Filename}
}
\value{
\code{sf} object
}
\description{
Coordinate reference system is always WGS84 in accordance with GeoJSON RFC.
}
\examples{
geojson_file <- system.file("geojson-example.json", package = 'yyjsonr')
read_geojson_file(geojson_file)
}
