% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{get_info}
\alias{get_info}
\title{Retrieve asset information from Yahoo Finance}
\usage{
get_info(
  ticker,
  modules = "summaryProfile",
  output = c("tibble", "list", "response", "request"),
  proxy = NULL
)
}
\arguments{
\item{ticker}{A ticker name or ticker object created with \code{get_tickers()}.}

\item{modules}{Character vector of module names to retrieve. Default is "summaryProfile".
See section "Available Modules" for common options.}

\item{output}{The type of output to return. Can be "tibble" (default), "list" (raw parsed JSON),
"response" (httr2 response), or "request" (httr2 request).}

\item{proxy}{Optional proxy settings for the request.}
}
\value{
Depending on the output parameter and number of modules requested:
\itemize{
\item For a single module with output="tibble": A tibble containing the module data
\item For multiple modules with output="tibble": A named list of tibbles, one per module
\item For output="list": The raw parsed JSON data
\item For output="response": The httr2 response object
\item For output="request": The httr2 request object
}
}
\description{
This function retrieves detailed asset information from Yahoo Finance's quoteSummary API.
It can fetch various types of data including asset profiles, financial statements, key statistics,
and more. The function supports retrieving multiple data modules in a single request.
}
\section{Available Modules}{

The \code{modules} parameter accepts any of the valid module names from Yahoo Finance API.
Common modules include:
\itemize{
\item \code{"assetProfile"}: Asset overview, description, industry, sector, officers
\item \code{"summaryProfile"}: Brief asset profile information
\item \code{"financialData"}: Key financial metrics and ratios
\item \code{"defaultKeyStatistics"}: Important statistics like market cap, P/E ratio
\item \code{"incomeStatementHistory"}: Annual income statements
\item \code{"incomeStatementHistoryQuarterly"}: Quarterly income statements
\item \code{"balanceSheetHistory"}: Annual balance sheets
\item \code{"balanceSheetHistoryQuarterly"}: Quarterly balance sheets
\item \code{"cashflowStatementHistory"}: Annual cash flow statements
\item \code{"cashflowStatementHistoryQuarterly"}: Quarterly cash flow statements
}

See \code{valid_modules} for a complete list of available modules.
}

\section{Authentication}{

This function requires authentication via two components:
\itemize{
\item \strong{A1 Cookie}: Session identifier
\item \strong{Crumb}: Security token
}

Authentication methods (in order of priority):
\enumerate{
\item Environment variables: \code{YFINANCE_CRUMB} and \code{YFINANCE_A1}
\item Saved auth file: \verb{~/.yfinance/auth}
\item Auto-generated using curl-impersonate (requires installation)
}

Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Sys.setenv(YFINANCE_CRUMB = "your-crumb")
Sys.setenv(YFINANCE_A1 = "your-a1-cookie")
}\if{html}{\out{</div>}}

See https://github.com/lwthiker/curl-impersonate for curl-impersonate installation.
Option 3 above expects \code{curl_chrome110} to be installed and available in the system path.
}

\examples{
\dontrun{
# Get a single ticker
apple <- get_tickers("AAPL")

# Get summary information
# using default module "summaryProfile"
apple_summary <- get_info(apple)

# Get basic company profile
apple_profile <- get_info(apple, modules = "assetProfile")

# Get key financial metrics
apple_financials <- get_info(apple, modules = "financialData")

# Get multiple modules as a list of tibbles
apple_data <- get_info(apple,
  modules = c("incomeStatementHistory", "balanceSheetHistory", "cashflowStatementHistory")
)

# Access specific financial statements
income_statement <- apple_data$incomeStatementHistory
balance_sheet <- apple_data$balanceSheetHistory

# Get raw JSON response for custom processing
apple_raw <- get_info(apple, modules = "assetProfile", output = "response")
}
}
