% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwres.vs.idv.bw.R
\name{cwres.vs.idv.bw}
\alias{cwres.vs.idv.bw}
\title{Box-and-whisker plot of conditional weighted residuals vs the independent
variable for Xpose 4}
\usage{
cwres.vs.idv.bw(object, ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.bw}}.}
}
\value{
Returns a stack of box-and-whisker plots of CWRES vs IDV.
}
\description{
This creates a box and whisker plot of conditional weighted residuals
(CWRES) vs the independent variable (IDV), and is a specific function in
Xpose 4.  It is a wrapper encapsulating arguments to the
\code{xpose.plot.bw} function. Most of the options take their default values
from xpose.data object but may be overridden by supplying them as arguments.
}
\details{
This creates a box and whisker plot of conditional weighted residuals
(CWRES) vs the independent variable (IDV), and is a specific function in
Xpose 4.  It is a wrapper encapsulating arguments to the
\code{\link{xpose.plot.bw}} function. Most of the options take their default
values from xpose.data object but may be overridden by supplying them as
arguments.

Conditional weighted residuals (CWRES) require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling bwplots are available. See
\code{\link{xpose.plot.bw}} and \code{\link{xpose.panel.bw}} for details.
}
\examples{
## Here we load the example xpose database 
xpdb <- simpraz.xpdb

cwres.vs.idv.bw(xpdb)

}
\seealso{
\code{\link{xpose.plot.bw}}, \code{\link{xpose.panel.bw}},
\code{\link[lattice]{bwplot}}, \code{\link{xpose.prefs-class}},
\code{\link{compute.cwres}}, \code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
