% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigateTestFileAddin.R
\name{navigateTestFileAddin}
\alias{navigateTestFileAddin}
\title{Navigates to test file}
\usage{
navigateTestFileAddin(selection = NULL, navigate = TRUE, abs_path = TRUE)
}
\arguments{
\item{selection}{String with file name and line number. (Character)

E.g. \code{"test_x.R:3:"}, which navigates to the third line of \code{"/tests/testthat/test_x.R"}.

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{navigate}{Whether to navigate to the file or return the extracted file name and line number. (Logical)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{abs_path}{Whether to return the full path or only the file name when \code{`navigate`} is \code{FALSE}.

\strong{N.B.} Mainly intended for testing the addin programmatically.}
}
\value{
Navigates to file and line number.

Does not return anything.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

\code{RStudio} Addin:
Extracts file name and (possibly) line number of a test file
from a selection or from clipboard content.
Navigates to the file and places the cursor at the line number.

Supported types of strings: \code{"test_x.R:3"}, \code{"test_x.R#3"}, \code{"test_x.R"}.

The string must start with \code{"test_"} and contain \code{".R"}.
It is split at either \code{":"} or \code{"#"}, with the second element (here \code{"3"}) being
interpreted as the line number.

See \code{`Details`} for how to set a key command.
}
\details{
\subsection{How to set up a key command in RStudio}{

After installing the package.
Go to:

\code{Tools >> Addins >> Browse Addins >> Keyboard Shortcuts}.

Find \code{"Go To Test File"} and press its field under \code{Shortcut}.

Press desired key command, e.g. \code{Alt+N}.

Press \code{Apply}.

Press \code{Execute}.
}
}
\seealso{
Other addins: 
\code{\link{assertCollectionAddin}()},
\code{\link{dputSelectedAddin}()},
\code{\link{initializeGXSFunctionAddin}()},
\code{\link{initializeTestthatAddin}()},
\code{\link{insertExpectationsAddin}()},
\code{\link{wrapStringAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{addins}
