% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlr_table.R
\name{update_theme}
\alias{update_theme}
\title{Update the \code{xlr_table} theme}
\usage{
update_theme(
  x,
  title_format = xlr_format(font_size = 12, text_style = "bold"),
  footnote_format = xlr_format(font_size = 9, text_style = "italic"),
  column_heading_format = xlr_format(font_size = 11, text_style = "bold", border =
    c("top", "bottom"), halign = "center", wrap_text = TRUE),
  table_body_format = xlr_format(border = c("top", "left", "right", "bottom"))
)
}
\arguments{
\item{x}{a \code{xlr_table}}

\item{title_format}{a \code{xlr_format} object to format the title}

\item{footnote_format}{a \code{xlr_format} object to format the footnote}

\item{column_heading_format}{a \code{xlr_format} object to format the column heading}

\item{table_body_format}{a \code{xlr_format} object to format the body}
}
\value{
Returns a \link{xlr_table} object.
}
\description{
This function allows you to update the underlying styling for your \link{xlr_table}.
This changes how the titles, footnotes, columns, and body objects look when
you write you \code{xlr_table} to \code{Excel} with \code{\link[=write_xlsx]{write_xlsx()}}.
}
\details{
If you want to change the style of the \emph{columns} in the data, you should convert them
to a \link{xlr_vector}, \link{xlr_numeric}, \link{xlr_integer} or \link{xlr_percent} type if they are
not already, and then update the \link{xlr_format} attribute, by setting
the \code{style} parameter.
}
\examples{
\dontshow{
  oldWd <- setwd(tempdir())
}
library(xlr)
# set up a basic table
bt <- xlr_table(mtcars,
                 "A title",
                 "A footnote")
# now we want to update the title
# This changes what it look likes when we print it to `Excel`
bt <- update_theme(bt,
                   xlr_format(font_size = 12,
                               text_style = c("bold","underline")))
# To see the change you must write to an Excel file
write_xlsx(bt,
           "example.xlsx",
           "Test")

\dontshow{
  # restore wd
  setwd(oldWd)
}
}
