% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutationFactory}
\alias{xegaPermMutationFactory}
\title{Configure the mutation function of a genetic algorithm.}
\usage{
xegaPermMutationFactory(method = "MutateGene")
}
\arguments{
\item{method}{The name of the mutation method.}
}
\value{
A permutation based mutation function.
}
\description{
\code{xegaPermMutationFactory} implements the selection
             of one of the gene mutation functions in this 
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.             
        
Current Support:

\enumerate{
\item "MutateGene" returns \code{xegaPermMutateGeneOrderBased}.
\item "MutateGeneOrderBased" returns \code{xegaPermMutateGeneOrderBased}.
\item "MutateGenekInversion" returns \code{xegaPermMutateGenekInversion}.
\item "MutateGene2Opt" returns \code{xegaPermMutateGene2Opt}.
\item "MutateGenekOptLK" returns \code{xegaPermMutateGenekOptLK}.
\item "MutateGeneGreedy" returns \code{xegaPermMutateGeneGreedy}.
\item "MutateGeneBestGreedy" returns \code{xegaPermMutateGeneBestGreedy}.
\item "MutateGeneMix" returns \code{xegaPermMutateMix}.
}
}
\examples{
xegaPermMutationFactory(method="MutateGene")
}
\seealso{
Other Configuration: 
\code{\link{lFxegaPermGene}},
\code{\link{xegaPermCrossoverFactory}()}
}
\concept{Configuration}
