% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutateGeneBestGreedy}
\alias{xegaPermMutateGeneBestGreedy}
\title{Mutate a gene (by inserting the best greedy path at a random start position with a random length of k).}
\usage{
xegaPermMutateGeneBestGreedy(gene, lF)
}
\arguments{
\item{gene}{A Permutation.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A Permutation
}
\description{
\code{xegaPermMutateGeneBestGreedy} mutates a permutation 
             by inserting the best greedy path of length \code{k} 
             at a random position \code{start}.
}
\details{
The path length \code{k} is exponentially decaying
             with exponential decay constant \code{lF$lambda()}.
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
gene<-xegaPermMutateGeneGreedy(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene, lFxegaPermGene)
}
\seealso{
Other Mutation: 
\code{\link{xegaPermMutateGene2Opt}()},
\code{\link{xegaPermMutateGeneGreedy}()},
\code{\link{xegaPermMutateGeneOrderBased}()},
\code{\link{xegaPermMutateGenekInversion}()},
\code{\link{xegaPermMutateGenekOptLK}()},
\code{\link{xegaPermMutateMix}()}
}
\concept{Mutation}
