% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeInitGene.R
\name{xegaGeInitGene}
\alias{xegaGeInitGene}
\title{Initialize a binary gene}
\usage{
xegaGeInitGene(lF)
}
\arguments{
\item{lF}{the local configuration of the genetic algorithm}
}
\value{
A binary gene (a named list):
        \itemize{
        \item \code{$evaluated}: FALSE. See package \code{xegaSelectGene}
        \item \code{$evalFail}:  FALSE. Set by the error handler(s)
                                 in package \code{xegaSelectGene} 
                                 in the case of failure.
        \item \code{$fit}:       Fitness vector.
        \item \code{$gene1}:     Binary gene.
        }
}
\description{
\code{xegaGeInitGene()} generates a random binary gene 
             with a given length.
}
\details{
In the binary representation of 
         package \code{xegaGeGene}, a \emph{gene} is a list with 
         \enumerate{
         \item \code{$evaluated} Boolean: TRUE if the fitness is known.
         \item \code{$fit}       The fitness of the genotype of 
                                 \code{$gene1}         
         \item \code{$gene1}     a bit string (the genetopye).
         }
}
\examples{
xegaGeInitGene(lFxegaGeGene)

}
\concept{Gene Generation}
