% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{leavesIncompleteDT}
\alias{leavesIncompleteDT}
\title{Returns the list of symbol identifiers
             of the leaves of a derivation tree.}
\usage{
leavesIncompleteDT(tree, ST, leavesList = list())
}
\arguments{
\item{tree}{Derivation tree.}

\item{ST}{Symbol table.}

\item{leavesList}{List of symbol identifiers.}
}
\value{
List of symbol identifiers.
}
\description{
For incomplete derivation trees, non-terminal symbols
             are leaves.
}
\details{
Must perform a depth-first left-to-right tree traversal to collect 
         all leave symbols (terminal and non-terminal symbols).
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
leavesIncompleteDT(a, g$ST) 

}
\seealso{
Other Decoder: 
\code{\link{decodeAndFixDT}()},
\code{\link{decodeCDT}()},
\code{\link{decodeDT}()},
\code{\link{decodeDTsym}()},
\code{\link{decodeTree}()}
}
\concept{Decoder}
