% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{decodeDTsym}
\alias{decodeDTsym}
\title{Decodes a derivation tree into a list of the leaf symbols
of the derivation tree.}
\usage{
decodeDTsym(tree, ST)
}
\arguments{
\item{tree}{Derivation tree.}

\item{ST}{Symbol table.}
}
\value{
List of the leaf symbols of the derivation tree.
}
\description{
Decodes a derivation tree into a list of the leaf symbols
of the derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
t1<-generateDerivationTree(sym=g$Start,sample(100, 10, replace=TRUE), G=g)
decodeDTsym(t1$tree, g$ST) 

}
\seealso{
Other Decoder: 
\code{\link{decodeAndFixDT}()},
\code{\link{decodeCDT}()},
\code{\link{decodeDT}()},
\code{\link{decodeTree}()},
\code{\link{leavesIncompleteDT}()}
}
\concept{Decoder}
